/*---------------------------------------------------------------------------*\

    FILE....: VPBCONF.CPP
    TYPE....: C++ Console program
    AUTHOR..: Jean-Michel Dault
    DATE....: 20/08/03

    This program gets the model and ports on an OpenSwitch board.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2003 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include "../src/vpbapi.h"
#include "../src/verbose.h"
#include "../src/hdaport.h"

#define BANKB		12
#define MAX_BOARDS	12


int main(int argc, char *argv[]) {
	extern int vpb_pconf[MAX_BOARDS][BANKB];
	VPB_CARD_INFO   *pcard_info[MAX_BOARDS], card_info[MAX_BOARDS];
	int 		i,j,h;
	int		tmp=0;
	int		numboards;
	int 		ports;

//	verbose(1);
//	vpb_seterrormode(VPB_DEVELOPMENT);

	h=vpb_open(1,1);
	numboards=vpb_get_num_cards();
	printf("\nCards detected:%d\n\n",numboards);

        for(i=0;i<numboards;i++) {
	  if(i!=0) h=vpb_open(i+1,1);
	  printf("BOARD %d\n",i+1);
	  ports=vpb_get_ports_per_card();
	  for(j=0;j<BANKB;j++) {
	    if(vpb_pconf[i][j]==-1) ports--;
	    printf("vpb_pconf[%d][%d] = %d\n",i,j,vpb_pconf[i][j]);
	  }
	  pcard_info[i]=&card_info[i];
	  vpb_get_card_info(i,pcard_info[i]);
	  if(ports==6) {
	    printf("MODEL         : V6PCI\n");
	  } else {
	    printf("MODEL         : %s\n",card_info[i].model);
	  }
	  printf("DATE          : %s\n",card_info[i].date);
	  printf("REVISION      : %s\n",card_info[i].rev);
	  printf("SERIAL NUMBER : %s\n",card_info[i].sn);
	  printf("STATIONS[%d]: ",i+1);
	  for(j=0;j<BANKB;j++) {
	    if(vpb_pconf[i][j]==1) printf("%d ",j+tmp);
	  }
	  printf("\n");
	  printf("TRUNKS[%d]: ",i+1);
	  for(j=0;j<BANKB;j++) {
	    if(vpb_pconf[i][j]==0) printf("%d ",j+tmp);
	  }
	  printf("\n\n");
	  tmp+=vpb_get_ports_per_card();
	  vpb_close(h);
	}

	return 0;
}

