/*---------------------------------------------------------------------------*\

    FILE....: VPBINFO.CPP
    TYPE....: C++ Console program
    AUTHOR..: Peter Wintulich
    DATE....: 12/feb/2003

    Function: Reads Manufacture details from each card installed and prints on 
    		the screen.
    
    Compile: gcc echo.cpp -lvpb -g -Wall -o echo -lm -pthread
    Run....: ./vpbinfo 

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>

#include "../src/vpbapi.h"
#include "../src/verbose.h"

int main(int argc, char * argv[])
{
	VPB_CARD_INFO	*data_ptr, data;
	int	        num_cards,h,i;
	int             major, minor, patchlevel;

	data_ptr= &data;
	//verbose(1);
	vpb_seterrormode(VPB_DEVELOPMENT);

	// open driver 
	
	h = vpb_open(1,1);
	num_cards= vpb_get_num_cards();

	vpb_get_driver_version(&major, &minor, &patchlevel);
	printf("Driver Version %d.%d.%d\n", major, minor, patchlevel);
	printf("VoiceTronix Card Details \n");
	printf("Number of cards %d\n\n",num_cards);
	
	for(i=0; i<num_cards; i++)
	{
		printf("CARD #%d.\n",i);
		vpb_get_card_info(i, data_ptr);
		printf("MODEL         : %s\n",data.model);
		printf("DATE          : %s\n",data.date);
		printf("REVISION      : %s\n",data.rev);
		printf("SERIAL NUMBER : %s\n\n",data.sn);
	}
	vpb_close(h);
	
	return 0;
}


	





