/* 
   trim.cpp
   David Rowe 10/10/01

   Chops the end of a wave file, useful for removing terminating DTMFs at 
   the end of a file.
*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include "../../src/vpbapi.h"
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#define	FS  8000	// sample rate		
#define N   160         // buffer size

void wave_get_size(void *wv, unsigned long *bytes);

int main(int argc, char *argv[]) {
	void *wr,*rd;
	char buf[N];
	int lose;
	short unsigned int mode;
	long unsigned int size,i;

	if (argc != 4) {
		printf("usage: trim InFile OutFile BytesToTrim\n");
		exit(0);
	}

	vpb_wave_open_read(&rd, argv[1]);
	vpb_wave_get_mode(rd, &mode);
	wave_get_size(rd, &size);
	vpb_wave_open_write(&wr, argv[2], mode);
  
	lose = atoi(argv[3]);
	size -= lose;

	for(i=0; i<size; i+=N) {
		vpb_wave_read(rd, buf, N);
		vpb_wave_write(wr, buf, N);
	}

	vpb_wave_close_read(rd);
	vpb_wave_close_write(wr);

	return 0;
}

