/*---------------------------------------------------------------------------*\

FILE....: TRAIN.CPP
TYPE....: C++ Module
AUTHOR..: David Rowe & Ben Kramer
DATE....: 20/8/98 

Functions for training VPB programmable tones.

\*---------------------------------------------------------------------------*/

#ifndef __TRAIN__
#define	__TRAIN__

#include "../../src/vpbapi.h"


// constants used in structure

#define	TRAIN_NMARK	100	// up to 100 candence/freq markers
#define	TRAIN_NCAD	10000	// cadence points between 0 and 20 seconds
#define	TRAIN_NSPEC	256	// spectrum points between 0 and 4 kHz

// return codes

#define	TRAIN_OK				0
#define	TRAIN_NOT_ENOUGH_CADENCE		-2
#define	TRAIN_INVALID_ON_THRESH			-3
#define	TRAIN_INVALID_OFF_THRESH		-4
#define TRAIN_INVALID_CADENCE_WINDOW		-5
#define TRAIN_INVALID_BANDWIDTH			-6
#define TRAIN_INVALID_E_THRESH			-7
#define TRAIN_WAVE_FILE_ERROR			-8
#define	TRAIN_WAVE_FILE_NOT_LINEAR		-9
#define	TRAIN_CANT_ALLOC_BUF			-10
#define	TRAIN_WAVE_READ_ERROR			-11
#define	TRAIN_NSAM_TO_SMALL			-12

typedef struct {
	// inputs
	short	OnThresh;	// level (ref 0dB) to switch on
	short	OffThresh;	// level (ref 0dB) to switch off
	short	CadenceWindow;	// Window (ms) for cadence transition
	short	Bandwidth;	// Bandwidth (Hz) for tone frequencies
	float	eThresh;	// threshold to look for second tone
	short	MagTol;		// tolerance (dB) of min magnitude

	// outputs
	short	Cadence[TRAIN_NCAD];	// cadence (signal energy) samples
	int	CadenceX[TRAIN_NCAD];	// cadence X axis in ms
	short	ncad;			// number of cadence points
	int	CadenceM[TRAIN_NMARK];	// cadence markers in ms
	short	nCadMark;		// number of cadence markers 
	short	Spectrum[TRAIN_NSPEC];	// spectrum in dB, covers 0-4kHz
	int	SpectrumX[TRAIN_NSPEC];	// spectrum x axis in Hz
	int	SpectrumM[TRAIN_NMARK];	// spectrum markers in Hz
	short	SpecMag[TRAIN_NMARK];	// spectrum marker mags in dB0
	short	nSpecMark;		// number of spectrum markers 
	float	r;			// converts Spectrum[] index to frequency in Hz

} TRAIN;

typedef struct 
{
	float real;
	float imag;
} COMPLX;

// uses a buffer of shorts as input

int WINAPI train_train(
	VPB_DETECT 	*tone,		// programmable tone definition
	TRAIN		*train,		// params controlling algorithm
	short		buf[],		// input samples (16 bit linear, 8 kHz)
	int		nsam		// number of input samples
);

// uses a wave file as input

int WINAPI train_train_from_linear_wave(
	VPB_DETECT 	*tone,		// programmable tone definition
	TRAIN		*train,		// params controlling algorithm
	char		file[]		// wave filename
);

void dft(
	COMPLX	* data,
	int	samples
);

#endif	// __TRAIN__
