/*---------------------------------------------------------------------------*\

    FILE....: TRING.CPP
    TYPE....: C++ Console program
    AUTHOR..: David Rowe
    DATE....: 27/02/01

    This program tests the ring detector hardware for the PCI card.  To run:

    1. Compile using 'make'
    2. connect a PBX line to any port.
    3. Run this program with './tring'
    4. Dial the number of the PBX line and check for ring events.
    5. Press return to exit.
    6. Repeat for each port.

    Results:

    DR 27/2/01 - All channels tested OK on DSpace PBX.  First ch also tested OK
    with Studio 308.  Triggers on every second ring which is the default set 
   in ring.cpp.
  	 
\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "../../src/vpbapi.h"
#include "../../src/verbose.h"
#include "../../src/mess.h"
#include "../kbhit.h"

#define MAX_CH 100

int arg_exists(int argc, char *argv[], char *arg);

int main(int argc, char *argv[])
{
	int		h[MAX_CH];
	VPB_EVENT	e;
	int	        ret,i,ch;
	char		s[VPB_MAX_STR];
	char            model_str[VPB_MAX_STR];
	int             ch_per_card, num_cards;

	verbose(0);
	vpb_seterrormode(VPB_DEVELOPMENT);
	
	h[0] = vpb_open(1,1);
	vpb_get_model(model_str);
	num_cards = vpb_get_num_cards();
	printf("model = %s\n", model_str);
	vpb_close(h[0]);
	
	if (!strcmp(model_str, "V12PCI")) {
	        ch_per_card = 12;
		ch = ch_per_card*num_cards;
		printf("==========> Got v12PCI\n");
	}
	if (!strcmp(model_str, "VPB4")) {
	        ch_per_card = 4;
		ch = ch_per_card*num_cards;
	}
	for(i=0; i<ch; i++) {
//		h[i] = vpb_open(1 + (i/ch_per_card) ,(i%ch_per_card)+1);
		h[i] = vpb_open(1,i+1);
		vpb_sethook_sync(h[i],VPB_ONHOOK);
	}

#ifndef WIN32
	if (arg_exists(argc, argv, "--ringall"))
		for(i=0; i<ch; i++)
			vpb_ring_station_async(h[i], VPB_RING_STATION_ON, 0);
#endif

	if (arg_exists(argc, argv, "--offhook"))
		for(i=0; i<ch; i++)
			vpb_sethook_sync(h[i], VPB_OFFHOOK);
		
	printf("Hit any key to exit!!\n");
	do {
		ret = vpb_get_event_async(&e);
		if (ret == VPB_OK) {
			vpb_translate_event(&e, s);
			printf("%s",s);
		}
		vpb_sleep(100);

	} while(!kbhit());

#ifndef WIN32
	if (arg_exists(argc, argv, "--ringall"))
		for(i=0; i<ch; i++)
			vpb_ring_station_async(h[i], VPB_RING_STATION_OFF, 0);
#endif
	verbose(1);
		
	for(i=0; i<ch; i++) {
		vpb_sethook_sync(h[i], VPB_ONHOOK);
		vpb_close(h[i]);
	}

	return 0;
}

int arg_exists(int argc, char *argv[], char *arg) {
  int i;

  for(i=0; i<argc; i++)
    if (strcmp(argv[i],arg) == 0)
      return i;

  return 0;
}

