/*---------------------------------------------------------------------------*\

	FILE....: TCOMM.CPP
	TYPE....: Microsoft C Program
	AUTHOR..: David Rowe
	DATE....: 19/11/97

	This program tests basic communications with the DSP.

\*--------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include "../../src/mess.h"
#include "../../src/comm.h"
#include "../../src/wobbly.h"

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#ifdef WIN32
#include <conio.h>
#else
int kbhit();
#endif

#define	BOARD		0	// which board in VPB Registry to use

int main()
{
	word	dnmess[PC_LPING];
	word	upmess[PC_LPING];
	long	pings,pongs;
	unsigned short      pongok;

	// initialise 

	try {
		mess_mprintf_on();

		Comm comm;

		// construct "ping" message
		
		dnmess[0] = PC_LPING;
		dnmess[1] = PC_PING;

		pings = 0;
		pongs = 0;

		while(!kbhit()) {
			// send message 

			comm.PutMessageVPB(BOARD, dnmess);
			pings++;

			// wait for message from DSP 

			while(comm.GetMessageVPB(BOARD, upmess) == OK) {
				pongok = (upmess[0] == DSP_LPONG) && 
					(upmess[1] == DSP_PONG);
				if (pongok)
					pongs++;
			}

			printf("pings [%ld] pongs [%ld]\r",pings, pongs);
		} // while(...
	}	// try ...

	catch (Wobbly w) {
		char	s[MAX_STR];
		w.translate(s);
		printf("exception caught: %s, file: %s line:%d\n"
		       ,s,w.file,w.line);
		exit(1);
	}
	return 0;

}

