/*---------------------------------------------------------------------------*\

    FILE....: TCALL.CPP
    TYPE....: C++ Console program
    AUTHOR..: David Rowe
    DATE....: 23/10/01

    Demonstrates vpb_call_async, useful for testing set up of call progress
    tones.  

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include "../../src/vpbapi.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "../kbhit.h"

void verbose(int);
int arg_exists(int argc, char *argv[], char *arg);

int main(int argc, char *argv[]) {
	int       h, finished, arg;
	VPB_EVENT e;
	char      s[VPB_MAX_STR];

	if (argc < 3) {
		printf("usage: tcall Port[1..] Number [--recwav FileName]\n");
		exit(0);
	}

	h = vpb_open(1,atoi(argv[1]));
	verbose(1);

	if ((arg = arg_exists(argc, argv, "--recwav")) != 0) {
		 vpb_record_file_async(h, argv[arg+1], VPB_LINEAR);
		 printf("recording to %s\n", argv[arg+1]);
	}

	vpb_sethook_sync(h,VPB_OFFHOOK);
	vpb_call_async(h, argv[2]);     

	finished = 0;
	do {
		while(vpb_get_event_async(&e) == VPB_OK) {
			vpb_translate_event(&e, s);
			printf("%s",s);

			if (e.type == VPB_CALLEND) {
				finished = 1;
			}
		}
		vpb_sleep(20);
	} while(!finished);
		
	printf("Press any key to hang up and exit....\n");
	while(!kbhit()) {
		while(vpb_get_event_async(&e) == VPB_OK) {
			vpb_translate_event(&e, s);
			printf("%s",s);
		}
		vpb_sleep(20);
	}
	vpb_record_terminate(h);
	vpb_sethook_sync(h,VPB_ONHOOK);

	verbose(0);
	vpb_close(h);
	return 0;

}

int arg_exists(int argc, char *argv[], char *arg) {
  int i;

  for(i=0; i<argc; i++)
    if (strcmp(argv[i],arg) == 0)
      return i;

  return 0;
}

