/*---------------------------------------------------------------------------*\

    FILE....: SILENCE.CPP
    TYPE....: C++ Console program
    AUTHOR..: John Kostogiannis
    DATE....: 26/4/02

    This program is used for testing the silence detector. This detector 
    may be used in instances where there is no hangup tone.
    This program works like this:

    1. It takes port 1 off hook and waits for a specified time of silence.
  

    Compile: gcc silence.cpp -lvpb -g -Wall -o silence -lm -pthread
    Run....: ./silence

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>

#include "../../src/vpbapi.h"
#include "../../src/verbose.h"
#include "../kbhit.h"


int ctwaitforsilence(int h, int event_type, int timeout_ms);

int arg_exists(int argc, char *argv[], char *arg);

int             finito;         // flag to signal the program is finished.
int             toff;           // silence duration in ms

int main(int argc, char * argv[])
{
	int	 h,i,arg,ch;
	int      tries, evt;
	void     *timer;

		//verbose(1);

	vpb_seterrormode(VPB_DEVELOPMENT);
	finito = 0;
	tries = 0;
	h = vpb_open(1,1);

	if ((arg = arg_exists(argc, argv, "--toff"))) {
	  toff = atoi(argv[arg+1]);
	  printf("Silence duration = %d ms ",toff);
	}
	else {
	  toff = 10000;
	  printf("Default silence duration = %d ms ",toff );
	}
	  
	/* set offhook */
	vpb_sethook_sync(h,VPB_OFFHOOK);      
		 
	 /* wait for silence */
	 evt = ctwaitforsilence(h,VPB_TONEDETECT,toff);

	if (evt==VPB_TIMEREXP);
	 vpb_sethook_sync(h,VPB_ONHOOK);
	printf("shutting down....\n");
	vpb_close(h);
	return 0;
}


int ctwaitforsilence(int h, int event_type, int timeout_ms) {
	char      s[VPB_MAX_STR];
	int       ret, state;
	VPB_EVENT e;   
	void      *timer;

	vpb_timer_open(&timer, h, 0, timeout_ms);
	if (timeout_ms != 0)
		vpb_timer_start(timer);

	state = 1;
	while(state) {
		ret = vpb_get_event_ch_async(h, &e);

		if (ret == VPB_OK) {
			vpb_translate_event(&e, s);
			printf("%s",s);
			if (e.type == event_type) {
				state = 1;
				if(e.data == VPB_GRUNT){
				   vpb_timer_restart(timer);
				}
			}			       
			if (e.type == VPB_TIMEREXP) {
				state = 0;
			}
		}
		else
			vpb_sleep(100);
	}
	  
	vpb_timer_close(timer);	
	if (state == 0)
		return e.type;
	else
		return -1;
}

int arg_exists(int argc, char *argv[], char *arg) {
  int i;

  for(i=0; i<argc; i++)
    if (strcmp(argv[i],arg) == 0)
      return i;

  return 0;
}

	





