/*-------------------------------------------------------------------------*\

  FILE..: JPDECCID.CPP
  AUTHOR: Peter Wintulich
  DATE..: 23/APR/2004

  Test program for testing JAPAN DID decoding module.  Attempts to decode
  DID signal from a wave file.

\*-------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "../../src/vpbapi.h"
#include "../../src/wobbly.h"
#include "../../src/verbose.h"

void wave_get_size(void *wv, unsigned long *bytes);
int arg_exists(int argc, char *argv[], char *arg);
void e_translate(int state);

int main(int argc, char *argv[])
{
	int 		i, state=1, arg ;
	void 		*w;
	unsigned long 	sz_bytes;
	VPB_CID_JP	*my_did = new VPB_CID_JP;

	if (argc < 2) {
		printf("usage: jpdeccid InputWaveFile\n");
		printf("       [--verbose] \n");
		exit(state);
	}

	vpb_cid_debug_on("debug.txt");

	if ((arg = arg_exists(argc, argv, "--verbose")) != 0) 
	{
		verbose(1);
		printf("Detail text mode enabled\n");
	}
	vpb_wave_open_read(&w, argv[1]);	// Open input file
	wave_get_size(w, &sz_bytes);		// Read file size
	assert(sz_bytes != 0);			// Allert if file empty
	char 		*buf = new char[sz_bytes];

	assert(buf != NULL);			// Check buffer allocated
	
	printf(" \nReading in wave file of size %ld bytes\n", sz_bytes);
	vpb_wave_read(w, buf, sz_bytes);

	printf("Starting decoding loop...\n");
	
	state = vpb_cid_jp_decode(my_did, (short*)buf, sz_bytes/sizeof(short));

	printf("Call return status = %d\n\n",state);
	if(state ==0)
	{
		printf("Decoded raw data Presentation Layer ...\n");
	
		for(i=0; i<my_did->raw_size  ;i++)
			printf("%2x,",my_did->raw[i]);
		printf(" \n");
		
		printf(" \nJP DID fields\n");
		printf("==================================================================\n");
		printf("Origenators Telephone Number   my_did->otn    = %s\n",my_did->otn);	
        	printf("OTA Reason for Absence         my_did->otnra  = %s\n",my_did->otnra);
	        printf("OTA Expansion Data             my_did->otnexp = %s\n",my_did->otnexp);
        	printf("DID Called Number Data         my_did->cnd    = %s\n",my_did->cnd); 
	        printf("DID Number Expansion Data      my_did->cndexp = %s\n",my_did->cndexp);
		printf("==================================================================\n");
	}
	else
		e_translate(state);
		//printf("Error returned, No data to display.\n");

	delete buf;

	return (state);
}

int arg_exists(int argc, char *argv[], char *arg)
{
  int i;

  for(i=0; i<argc; i++)
    if (strcmp(argv[i],arg) == 0)
      return i;

  return 0;
}

void e_translate(int state)
{
	switch(state)
	{
		case 1:
			printf("EOF while searching for mark signal\n");
			break;
		case 2:
			printf("EOF while Measuring mark signal\n");
			break;
		case 4:
			printf("EOF before DLE\n");
			break;
		case 5:
			printf("byte not SOH\n");
			break;
		case 6:
			printf("Parity error\n");
			break;
		case 7:
			printf("byte not header\n");
			break;
		case 8:
			printf("Parity error\n");
			break;
		case 9:
			printf("byte not STX\n");
			break;
		case 10:
		case 11:
			printf("Parity error\n");
			break;
		case 12:
			printf("Parity in Press Layer data\n");
			break;
		case 13:
			printf("Byte not DLE\n");
			break;
		case 14:
			printf("Byte not ETX\n");
			break;
		case 15:
			printf("CRC Bad\n");
			break;
			
	}
	return;
}
