#include <stdio.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include "../../src/vpbapi.h"
#include "../../src/verbose.h"

void printtime(void);
int main(int argc, char *argv[])
{
	char	dialstr[64];
	int	h;
	int 	i;
	int	ret=0;
	printf("Call Throtling testing\n");
	if (argc >1 ){
		strcpy(dialstr,argv[1]);
	}
	else {
		printf("Usage: %s <number to call>\n",argv[0]);
		return(1);
	}
	printf("Opening card...\n");
	h = vpb_open(1,1);
	vpb_seterrormode(VPB_ERROR_CODE);
//	verbose(1);
	
	for(i=0;i<15;i++){
		printtime();
		printf("Placing call to [%s]...\n",dialstr);
		ret  = vpb_call_sync_jp(h,dialstr);
		printtime();
		printf("Returned [%d]\n",ret);
		if (ret == 1 && i< 3){
			sleep(30);
		}
		else {
			sleep(15);
		}
	}
	verbose(0);

	vpb_close(h);
}

void printtime(void)
{
	time_t  curtime;
	struct  tm *loctime;
	curtime = time (NULL);
	loctime = localtime (&curtime);
	printf("%04d/%02d/%02d-%02d:%02d:%02d ",
		loctime->tm_year+1900,
		loctime->tm_mon+1,
		loctime->tm_mday,
		loctime->tm_hour,
		loctime->tm_min,
		loctime->tm_sec);
}
