/* 
   twave.cpp
   David Rowe 5/8/01

   Test program for wave write functions.
*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include "../../src/vpbapi.h"
#include <string.h>

#define N 16000

int main() {
  void *w;
  char buf[N];
  int i;

  vpb_wave_open_write(&w, "w.wav", VPB_LINEAR);
  memset(buf, 0, N);

  for(i=0; i<100; i++)
    vpb_wave_write(w, buf, N);
  vpb_wave_close_write(w);

  return 0;
}

