/*---------------------------------------------------------------------------*\

    FILE....: TWATCHDOG.CPP
    TYPE....: C++ program
    AUTHOR..: David Rowe
    DATE....: 27/8/02

    Test program for V12PCI watchdog timer.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2002 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>

#include "../../src/vpbapi.h"
#include "../kbhit.h"

int main(int argc, char * argv[])
{
	int	        h,i;

	vpb_seterrormode(VPB_DEVELOPMENT);

	h = vpb_open(1,1);
	vpb_watchdog_enable(h,1);

	printf("Watchdog enabled...press any key and wait 8 seconds for it to"
	       " fire\n");
	i=1000;
	while(!kbhit()) {
		vpb_watchdog_reset(h);
		vpb_sleep(100);
	}
	for(i=0;i<100;i++){
		printf("%d00 milli seconds...\n",i);
		vpb_sleep(100);
		if(kbhit()){
			i=0;
			vpb_watchdog_reset(h);
		}
	}

	vpb_close(h);
	printf("\n");

	return 0;
}



