/*---------------------------------------------------------------------------*\

    FILE....: TSEIZURE.CPP
    TYPE....: C Console program
    AUTHOR..: David Rowe
    DATE....: 9/1/01

    This program tests the on/off hook action of the VPB card.

    Compile: gcc tseizure.cpp -o tseizure -lm -lvpb -pthread -Wall -g
    Run:./tseizure

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>

#include "../../src/apifunc.h"
#include "../../src/coff.h"
#include "../../src/vpbapi.h"
#include "../../src/verbose.h"
#include "../../src/mess.h"
#include "../../src/generic.h"
extern "C" {
#include "../../src/alawmulaw.h"
}

#define	FRAMES	300
#define	N		160
		
// "hidden" API functions useful for VT debug

int WINAPI vpb_comp_load(unsigned short board);
int WINAPI vpb_echo_canc_force_adapt_on();
int WINAPI vpb_echo_canc_force_adapt_off();
int WINAPI vpb_echo_canc_disable();
int WINAPI vpb_echo_canc_enable();
void playrec_diag(unsigned short *play, unsigned short *rec);
void playrec_diag_reset();
void playtone_sync_terminate(void* d);

// local functions

void studio308_off_hook(int h, int max_tries);


// software fix for Nortel Studio 308 seizure problem
// checks for dial tone after attempted off hook, retires if
// no dial tone after a period
// DR 15/7/98

void studio308_off_hook(int h, int max_tries)
{
	VPB_EVENT	e;
	char		s[VPB_MAX_STR];
	int			success;
	int			tries = 0;
	void		*t;
	int			id, time_out;

	id = vpb_timer_get_unique_timer_id();
	vpb_timer_open(&t, h, id, 4000);
	vpb_timer_start(t);
	
	do {
		vpb_sethook_sync(h,VPB_OFFHOOK);

		// wait for dial tone on channel 2

		vpb_get_event_sync(&e, 0);
		vpb_translate_event(&e, s);
		printf("%s",s);

		success = (e.type == VPB_TONEDETECT) && (e.handle == h) && (e.data == VPB_DIAL);
		time_out = (e.type == VPB_TIMEREXP) && (e.handle == h) && (e.data == id);
		
		if (time_out) {
			vpb_sethook_sync(h,VPB_ONHOOK);
			vpb_timer_start(t);
			vpb_sleep(500);
			tries++;
		}

	}  while(!success && (tries < max_tries));

	vpb_timer_close(t);
	if (success)
		printf("studio 308 off hook success after %d tries\n", tries);
}

void test_studio308_off_hook() {
	int			h;
	int			c=0;

	vpb_seterrormode(VPB_DEVELOPMENT);
	verbose(1);
	h = vpb_open(1,4);
	vpb_sethook_sync(h,VPB_ONHOOK);
	vpb_sleep(500);
	
	while(1) {
		studio308_off_hook(h, 10);
		vpb_sethook_sync(h, VPB_ONHOOK);
		vpb_sleep(3000);
		printf("count = %d\r",c++);
	}
	
	vpb_close(h);
}


int main() {
	test_studio308_off_hook();
	return 0;
}
