/*--------------------------------------------------------------------------*\

    FILE....: MTPCI.CPP
    TYPE....: Linux C++ Program
    AUTHOR..: David Rowe
    DATE....: 16/4/00

    PCI version of the VPB memory test program (see also mtisa.cpp).  This 
    program tests the PCI device driver and V4PCI card DSP memory by writing
    and reading back a block of DSP memory.  Useful as a basic hardware test
    program - if this doesnt work - nothing else will.  Requires the vpb
    kernel mode driver to be installed (see vpb.c).

    Compile: gcc mtpci.cpp -o mtpci -Wall
    Run....: ./mtpci

\*--------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/ioctl.h>
#include <unistd.h>

#include "../src/vpb_ioctl.h"

#define SIZE_WD 0x100

int main() {
	int               fd;
	int               i;
	int               ret,errors;
	unsigned short    bufwr[SIZE_WD];
	unsigned short    bufrd[SIZE_WD];
	VPB_DATA          params;

	fd = open("/dev/vpb0",O_RDWR);
	assert(fd != -1);

	for(i=0; i<SIZE_WD; i++)
		bufwr[i] = i;

	// set up ioctl params
	params.length = SIZE_WD;
	params.dsp_addr = 0x0;
	params.pci_num = 0;

	// Reset DSP
	params.data = NULL;
	ret = ioctl(fd, VPB_IOC_PCI_DSP_RESET, &params);
	assert(ret != -1);

	// block write to DSP RAM
	params.data = bufwr;
	ret = ioctl(fd, VPB_IOC_PCI_BLOCK_WRITE, &params);
	assert(ret != -1);

	// block read from DSP RAM
	params.data = bufrd;
	ret = ioctl(fd, VPB_IOC_PCI_BLOCK_READ, &params);
	assert(ret != -1);

	close(fd);

	// check read block is the same as write block
	errors = 0;
	for(i=0; i<SIZE_WD; i++) {
		printf("[0x%04x] wr: 0x%04x rd: 0x%04x\n",i,bufwr[i],bufrd[i]);
	}

	printf("PASSED!\n");

	return 0;
}

