/*---------------------------------------------------------------------------*\

    FILE....: TSBRIDGE.CPP
    TYPE....: C++ Console program
    AUTHOR..: Ben Kramer
    DATE....: 28/02/03

    Bridges two ports using the Soft Firmware bridging feature.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <math.h>
#include "../kbhit.h"

#include "../../src/vpbapi.h"
#include "../../src/verbose.h"
#include "../../src/comm.h"

#ifndef WIN32
extern Comm *vpb_c;   // ptr to comm object
void record_set_hw_gain(int handle, float gain, Comm *c);
#endif 

#define CH              4
#define	BUF_SIZE        160	// size of processing frame (samples) (20ms)
#define DEF_PG          12      // default play gain
#define DEF_RG          -3      // default record gain
#define MAX_CH 100

int arg_exists(int argc, char *argv[], char *arg);

int main(int argc, char * argv[])
{
	int	        h[MAX_CH],ret,i;
	VPB_EVENT	e;
	char		s[VPB_MAX_STR];
	char            model_str[VPB_MAX_STR];
	int             num_cards,totchan=0;

	if (argc < 3) {
	       printf("usage: %s <port1> <port2> [<port3>...] \n",argv[0]);
	       printf("\t<portN> = Port number (starting from 0) \n");
	       printf("\t this will listen port2... to port1\n");
	       exit(0);
	}
	
	// find out how many boards we have!
	printf("Checking for number of cards...\n");
	h[0]=vpb_open(1,1);
	num_cards = vpb_get_num_cards();
	printf("Found %d cards ...\n", num_cards);
	vpb_close(h[0]);


	for (i=0;i<num_cards;i++){
		printf("Checking card %d for number of ports...\n",i);
		h[0]=vpb_open(1+i,1);
		vpb_get_model(model_str);
		if (!strcmp(model_str, "V12PCI")) {
			totchan+=12;
		}
		else if (!strcmp(model_str, "V6PCI")) {
			totchan+=6;
		}
		else if (!strcmp(model_str, "VPB4")) {
			totchan+=4;
		}
		vpb_close(h[0]);
	}
	printf("Found a total of %d ports...\n",totchan);
	/*
	int port1=atoi(argv[1]);
	int port2=atoi(argv[2]);
	*/

	float rg = DEF_RG;
	float pg = DEF_PG;

       

	for (i=0;i<totchan;i++){
		h[i] = vpb_open(1+i/12,1+ i % 12);
		// set up play and record gain plan
		vpb_record_set_hw_gain(h[i], rg); 
		vpb_play_set_hw_gain(h[i], pg); 
	}
	
	//Listen 'em!
	for(i=2;i<argc;i++){
		vpb_listen(h[atoi(argv[i])],h[atoi(argv[1])],VPB_BRIDGE_ON);
		printf("Listening port %d to %d...\n",atoi(argv[i]),atoi(argv[1]));
	}

	do {
		ret = vpb_get_event_async(&e);
		if (ret == VPB_OK) {
			vpb_translate_event(&e, s);
			printf("%s",s);
		}

		vpb_sleep(20);

	} while(!kbhit());


	for(i=0;i<totchan;i++){
		vpb_close(h[i]);
	}

	return 0;
}

int arg_exists(int argc, char *argv[], char *arg) {
  int i;

  for(i=0; i<argc; i++)
    if (strcmp(argv[i],arg) == 0)
      return i;

  return 0;
}








