/*--------------------------------------------------------------------------*\

    FILE....: tfsync.cpp
    TYPE....: Linux C++ Program
    AUTHOR..: David Rowe
    DATE....: 25/3/03

    Test program for debugging frame sync on V12PCI. 

\*--------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         V12PCI CT Card Software

         Copyright (C) David Rowe 2001 david@voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include "../../src/pci.h"
#include "../../src/vpbapi.h"
#include "../kbhit.h"

int main(int argc, char *argv[]) {
	int resync, fd, resyncpos;

	fd = pci_open();

	while(!kbhit()) {
	  pci_fsync_read(fd, 0, &resync, &resyncpos);
	  printf("resync = %d, pos %d\n", resync, resyncpos);
	  vpb_sleep(100);
	}

	pci_close(fd);
	
	return 0;
}

