/*
  tdtmf.cpp
  David Rowe 8/7/02

  Tests simultaneous multiple DTMF detection.  Run without any ports
  connected so that DTMFs tramsnitted out of each port "echo" back
  to that port.
*/

#include "../../src/vpbapi.h"
#include <stdio.h>
#include <stdlib.h>
#include <string>
#include "../kbhit.h"
#include "../threads.h"

#define CH 12

int             finish;
int             threads_active; // the number of active threads.
pthread_mutex_t mutex;          // mutex to protect shared data
int             digits_tx;      // number of digits transmitted

void *port_thread(void *pv);
int arg_exists(int argc, char *argv[], char *arg);

int main(int argc, char *argv[]) {
	int       i, h[CH], ret;
	VPB_EVENT e;
	char      s[VPB_MAX_STR];
	pthread_t aport_thread[CH];
	int       digits_rx;

	pthread_mutex_init(&mutex,NULL);
	finish = 0;
        digits_tx = digits_rx = 0;
	for(i=0; i<CH; i++) { 
		h[i] = vpb_open(1,i+1);
		vpb_sethook_sync(h[i], VPB_ONHOOK);

		pthread_create(&aport_thread[i], NULL, port_thread, 
			       (void*)&h[i]);
		
	}

	do {		
		ret = vpb_get_event_async(&e);

		if (ret == VPB_OK) {
			vpb_translate_event(&e, s);
			printf("%s",s);
			if (e.type == VPB_DTMF) {
				digits_rx++;
				printf("digits_tx %d digits_rx %d\n",
				       digits_tx, digits_rx);
			}
		}
		else
			vpb_sleep(100);
		
	} while(!kbhit());

	finish = 1;
	printf("shutting down....\n");
	while(threads_active) {
		vpb_sleep(100);
		printf("threads active: %d\r", threads_active);
	}

	for(i=0; i<CH; i++) {
		vpb_close(h[i]);
	}

	return 0;
}

void *port_thread(void *pv) {
	int       h = *(int*)pv;

	pthread_mutex_lock(&mutex);
	threads_active++;
	pthread_mutex_unlock(&mutex);

	while(!finish) {
		vpb_dial_sync(h, "1234567890#*");
		pthread_mutex_lock(&mutex);
		digits_tx += 12;
		pthread_mutex_unlock(&mutex);
		vpb_sleep(5000);
	}

	pthread_mutex_lock(&mutex);
	threads_active--;
	pthread_mutex_unlock(&mutex);

	return NULL;
}

int arg_exists(int argc, char *argv[], char *arg) {
  int i;

  for(i=0; i<argc; i++)
    if (strcmp(argv[i],arg) == 0)
      return i;

  return 0;
}
