/*
  tdialtone.cpp
  David Rowe 15/3/02

  Tests alternative dialing and playing tones.

*/

#include "../../src/vpbapi.h"
#include <stdio.h>
#include <stdlib.h>
#include <string>
#include "../kbhit.h"

VPB_TONE tone = {500,0,0,-10,-100,-100,3000,0};
int ctwaitforevent(int h, void *timer,int event_type,int data,int timeout_ms);
int finish;
int arg_exists(int argc, char *argv[], char *arg);

int main(int argc, char *argv[]) {
	int       h;
        int       tries; 
	void      *timer;

	h = vpb_open(1,1);
	tries = 0;

        vpb_timer_open(&timer, h, 0, 1000);

	vpb_sethook_sync(h, VPB_OFFHOOK);

	do {
		tries++;

		// sync versions
		vpb_dial_sync(h, "123");
		vpb_playtone_sync(h, &tone);

		// async versions
		vpb_dial_async(h, "123");
		ctwaitforevent(h, timer, VPB_DIALEND, 0, 2000);
		vpb_playtone_async(h, &tone);
		ctwaitforevent(h, timer, VPB_DIALEND, 0, 2000);

		printf("tries = %d\n",tries);
	} while(!kbhit());

        vpb_sethook_sync(h, VPB_ONHOOK);

	vpb_close(h);
	return 0;
}

int ctwaitforevent(int h,void *timer,int event_type,int data,int timeout_ms) {
  char      s[VPB_MAX_STR];
  int       ret, state;
  VPB_EVENT e;   

  vpb_timer_change_period(timer, timeout_ms);
  if (timeout_ms != 0)
    vpb_timer_start(timer);

  state = 1;
  while(state && !finish) {
    ret = vpb_get_event_ch_async(h, &e);

    if (ret == VPB_OK) {
      vpb_translate_event(&e, s); s[strlen(s)-1]=0;

      if ((e.type == event_type) && (e.data == data)) {
	state = 0;
      }
      if (e.type == VPB_TIMEREXP) {
	state = 0;
      }
    }
    else
      vpb_sleep(100);
  }
	  
  vpb_timer_stop(timer);	
  if (state == 0)
    return e.type;
  else
    return -1;
}

int arg_exists(int argc, char *argv[], char *arg) {
  int i;

  for(i=0; i<argc; i++)
    if (strcmp(argv[i],arg) == 0)
      return i;

  return 0;
}
