/*---------------------------------------------------------------------------*\

    FILE....: TBUFTHREAD.CPP
    TYPE....: C++ Program
    AUTHOR..: David Rowe
    DATE....: 7/3/02

    Test program for the use of the vpb_xxx_buf_xxx functions in situations
    where vpb_xxx_buf_finish is in a different thread to vpb_xxx_buf_sync.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2002 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "../../src/vpbapi.h"
#include "../kbhit.h"
#include "../threads.h"

#define NBUF      160
#define WAIT_TERM 1000
#define CH        4

void *play_thread(void *pv);
void *play_terminate_thread(void *pv);
void *record_thread(void *pv);
void *record_terminate_thread(void *pv);

pthread_mutex_t mutex;
int its;
int threads;
int finito;
int plays[CH];
int recs[CH];

int main() {
        pthread_t thread1[CH], thread2[CH];
	int       h[CH];
	int       i;

	// initialise
	vpb_seterrormode(VPB_DEVELOPMENT);
	its = 0;
	threads = 0;
	finito = 0;
	pthread_mutex_init(&mutex, NULL);

	for(i=0; i<CH; i++) {
	  h[i] = vpb_open(1,i+1);
	  plays[i] = 0;
	  recs[i] = 0;
	  	  
	  pthread_create(&thread1[i], NULL, play_terminate_thread, 
	  		 (void*)&h[i]);
	  
	  pthread_create(&thread2[i], NULL, record_terminate_thread, 
		  	 (void*)&h[i]);
	  
	}

	printf("Press any key to finish\n");
	while(!kbhit()) {
	  vpb_sleep(1000);
	  printf("its: %04d plays: ", its);
	  for(i=0; i<CH; i++)
	    printf("%04d ",plays[i]);
	  printf("recs: ");
	  for(i=0; i<CH; i++)
	    printf("%04d ",recs[i]);
	  printf("\n");
	}

	finito = 1;
	while(threads) {
	  vpb_sleep(100);
	  printf("Shutting down: %d threads still active\r", threads);
	}
	printf("\n");

	for(i=0; i<CH; i++) {
	  vpb_close(h[i]);
	}
	return 0;
}

// start playing then terminate playing after a few seconds
void *play_terminate_thread(void *pv) {
  int       h = *(int*)pv;
  pthread_t thread;
  void      *retval;

  pthread_mutex_lock(&mutex);
  threads++;
  pthread_mutex_unlock(&mutex);

  while(!finito) {
    //plays[h] = 0;
    pthread_create(&thread, NULL, play_thread, (void*)&h);
    vpb_sleep(WAIT_TERM);
    vpb_play_terminate(h);
    //plays[h] = 1;
    vpb_play_buf_finish(h);
    //plays[h] = 2;
    pthread_mutex_lock(&mutex);
    its++;
    plays[h]++;
    pthread_mutex_unlock(&mutex);
    pthread_join(thread, &retval);
  }

  pthread_mutex_lock(&mutex);
  threads--;
  pthread_mutex_unlock(&mutex);
  
  return NULL;
}

// play until terminated by other thread
void *play_thread(void *pv) {
  int   h = *(int*)pv;
  char  buf[NBUF];
  int   ret;
  
  vpb_play_buf_start(h, VPB_MULAW);

  do {
    ret = vpb_play_buf_sync(h, buf, NBUF);
  } while(ret == VPB_OK);
  
  return NULL;
}

// start recording then terminate playing after a few seconds
void *record_terminate_thread(void *pv) {
  int       h = *(int*)pv;
  pthread_t thread;
  void      *retval;

  pthread_mutex_lock(&mutex);
  threads++;
  pthread_mutex_unlock(&mutex);

  while(!finito) {
    //recs[h] = 0;
    pthread_create(&thread, NULL, record_thread, (void*)&h);
    vpb_sleep(WAIT_TERM);
    vpb_record_terminate(h);
    //recs[h] = 1;
    vpb_record_buf_finish(h);
    //recs[h] = 2;
    pthread_mutex_lock(&mutex);
    its++;
    recs[h]++;
    pthread_mutex_unlock(&mutex);
    //recs[h] = 3;
    pthread_join(thread, &retval);
  }

  pthread_mutex_lock(&mutex);
  threads--;
  pthread_mutex_unlock(&mutex);
  
  return NULL;
}

// record until terminated by other thread
void *record_thread(void *pv) {
  int   h = *(int*)pv;
  char  buf[NBUF];
  int   ret;

  vpb_record_buf_start(h, VPB_MULAW);
  do {
    ret = vpb_record_buf_sync(h, buf, NBUF);
  } while(ret == VPB_OK);

  return NULL;
}


