/*--------------------------------------------------------------------------*\

    FILE....: POKE.CPP
    TYPE....: C++ Program
    AUTHOR..: David Rowe
    DATE....: 28/2/02

    Test program for Voicetronix VPB4 (ISA), VPB8L (ISA), V4PCI (PCI) cards.  
    "Pokes" data into a single DSP memory location and reads back the result.
    
\*--------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include "../src/generic.h"
#include "../src/hip.h"
#include "../src/vpbreg.h"

int main(int argc, char *argv[]) {
	int               i;
	unsigned short    bufwr;
	unsigned short    bufrd;
	int               addr,val;
	int               base;		    // ISA base addr or PCI board num
	int               repeats;

	if (argc < 2) {
		printf("usage: poke BASE Addr WriteValue Repeats\n");
		printf("e.g. for ISA 'poke 0x300 0x100 0xffff 10'\n");
		printf("e.g. for PCI 'poke 0 0xf000 0x0800 5'\n");
		exit(0);
	}

	// init
	sscanf(argv[1], "%x", &base);
	sscanf(argv[2], "%x", &addr);
	sscanf(argv[3], "%x", &val); bufwr = (unsigned short)val;
	sscanf(argv[4], "%d", &repeats);

	// work out which device driver we are using
	unsigned short numvpb;
	VPBRegister v = VPBRegister(&numvpb);
	VPBREG *vr = v.reg;

	// OK, init host interface port (HIP)
	Hip h = Hip(vr->ddmodel);

	// Place DSP in reset
	h.InitVpb(base);
	h.DspReset(0);
	
	for(i=0; i<repeats; i++) {
		h.WriteDspSram(0, (unsigned short)addr, 1, &bufwr);
		h.ReadDspSram(0, (unsigned short)addr, 1, &bufrd);
		printf("%02d: [0x%04x] wr=0x%04x rd=0x%04x\n", i, addr, 
		       bufwr, bufrd);
	}

	return 0;
}
