/*---------------------------------------------------------------------------*\

	FILE....: measdelay.cpp
	TYPE....: C++ Program
	AUTHOR..: David Rowe
	DATE....: 21/5/03

	Test program to measure the relative delay betwwen a transmitted and
	received impulse.  Used for evaluating echo canceller performance.

\*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2003 Voicetronix www.voicetronix.com

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <pthread.h>
#include <string.h>
#include "../../src/vpbapi.h"
#include "../kbhit.h"

#define	N        320	// size of processing frame (samples) (20ms)

// local functions
 
int main(int argc, char *argv[])
{
	int   line1,i,doneit=0;
        short txbuf[N], rxbuf[N];
	int   max_so_far, max_offset, current_offset;
	ulong	total_count=0;

	if (argc < 2) {
		printf("usage: measdelay Port1[1..]\n");
		exit(0);
	}

	// set up tx buuffer

	for(i=0; i<N; i++) {
		txbuf[i] = 0;
	}
	txbuf[0] = 8000;

	line1 = vpb_open(1, atoi(argv[1]));


	vpb_record_buf_start(line1, VPB_LINEAR);
	vpb_play_buf_start(line1, VPB_LINEAR);

	current_offset = 0;

	printf("Started, hit enter key to finish\n");
	while(!kbhit()) {
		total_count++;
		vpb_play_buf_sync(line1, (char*)txbuf, sizeof(txbuf));
		vpb_record_buf_sync(line1, (char*)rxbuf, sizeof(rxbuf));

		max_so_far = 0;
		for(i=0; i<N; i++) {
			if (rxbuf[i] > max_so_far) {
				max_so_far = rxbuf[i];
				max_offset = i;
			}
		}
		doneit++;
		if (doneit==100){
			printf("\noffset is %d at test %ld", current_offset, total_count);
			doneit=0;
		}


		if (max_offset != current_offset) {
			printf("\noffset changed to %d at test %ld", max_offset,total_count);
			current_offset = max_offset;
		}
	}

	vpb_record_buf_finish(line1);
	vpb_play_buf_finish(line1);
	vpb_close(line1);

	printf("\n Tested %ld times\n",total_count);

	return 0;
}	

