/*---------------------------------------------------------------------------*\

	FILE....: loadrun.cpp
	TYPE....: C Program
	AUTHOR..: David Rowe
	DATE....: 11/2/01

	Loads a DSP program into a VPB and starts it running.  Used during
	development for test programs that dont involve any Host PC code.
	
	Compile: gcc loadrun.cpp -o loadrun -lvpb -g -Wall -lm -pthread
	Run....: ./loadrun 

\*--------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include "../src/comm.h"
#include "../src/coff.h"
#include "../src/hip.h"
#include "../src/timer.h"
#include "../src/generic.h"
#include "../src/wobbly.h"

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>

int  main(int argc, char *argv[]) {
	VPBREG      *vr;
	VPBRegister *v;
	Hip         *hip;
	char        *firmware;
	unsigned short      numvpb;

	if (argc != 2) {
		printf("usage: %s FirmwareFile\n",argv[0]);
		exit(0);
	}
	firmware = argv[1];
	assert(firmware != NULL);

	try {
		numvpb = 1;
		v = new VPBRegister(&numvpb);
		assert(v != NULL);
		vr = v->reg;
		hip = new Hip(vr->ddmodel);
		assert(hip != NULL);
		hip->InitVpb(vr[0].base);
		coff_load_dsp_firmware(hip, 0, firmware);
		hip->DspRun(0);
		printf("firmware loaded and DSP running....\n");
	}

	catch (Wobbly w) {
		char	s[MAX_STR];
		
		w.translate(s);
		
		if (w.file[0] != 0) 
			printf("exception caught: %s, %s, line = %d\n"
			       ,s, w.file, w.line);
		else
			printf("exception caught: %s\n",s);
	}

	return 0;
}
