/*--------------------------------------------------------------------------*\

    FILE....: LINEV_HIP.CPP
    TYPE....: C++ Program
    AUTHOR..: Peter Wintulich
    DATE....: 1/DEC/03

    Test HIP level function of Line voltage monitoring.

\*--------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include "../src/generic.h"
#include "../src/hip.h"
#include "../src/vpbreg.h"

int kbhit();

#define SIZE_WD   0xffff

int main(int argc, char *argv[]) {
	//int               	i,j;
	word    		wr[128];
	word    		rd[128];
	//unsigned short		addr =0x0a000;
	int			base = 1;
	//int               	fails = 0;
	//int              	length = SIZE_WD;
	int	min,max,x;

	/*
	if (argc < 2)
       	{
		printf("usage: walk BASE\n");
		printf("e.g. for ISA 'walk 0x300' or 'walk 0x310'\n");
		printf("e.g. for PCI 'walk 0' or 'walk 1'\n");
		exit(0);
	}
	*/

	// init
	/*
	sscanf(argv[1], "%x", &base);
	if (argc == 3)
		sscanf(argv[2], "%x", &length);
	assert((length > 0) && (length <= SIZE_WD));
	*/
	base =0;
	
	// work out which device driver we are using
	unsigned short numvpb;
	VPBRegister v = VPBRegister(&numvpb);
	VPBREG *vr = v.reg;

	// OK, init host interface port (HIP)
	Hip h = Hip(vr->ddmodel);

	// Place DSP in reset
	h.InitVpb(base);
//	h.DspReset(0);	// dont need this for line voltage sense ?
	h.DspRun(0);	// need to take chips out of reset.
	vpb_sleep(1000);
	
		h.ReadIic(0, 0x0a010, 16, &rd[0]);
	printf("Voltages=%x, %x,%x,%x,%x, %x,%x,%x,%x\n",rd[0],rd[1],rd[2],rd[3],rd[4],rd[5],rd[6],rd[7],rd[8]);			
	printf(", %x,%x,%x,%x. ->%x,%x,%x,%x\n",rd[9],rd[10],rd[11],rd[12],rd[13],rd[14],rd[15],rd[16]);			
	min=max=rd[9];
	for(x=0;x<4;x++)
		wr[x] = 15;
	//h.WriteIic(0, 0x0a014, 4, &wr[0]);
	printf("h.WriteIic- %x\n",wr[0]);
	vpb_sleep(1000);
do{
		h.ReadIic(0, 0x0a000, 12, &rd[0]);
	//sleep(1);
	//if (min>rd[5]) min=rd[5];
	//if (max<rd[5]) max=rd[5];
	printf("h,ReadIic=%04x, %02x,%02x,%02x,%02x, %02x,%02x,%02x,%02x, V's %02x,%02x,%02x,%02x\n",rd[0],rd[1],rd[2],rd[3],rd[4],rd[5],rd[6],rd[7],rd[8],rd[9],rd[10],rd[11],rd[12]);			
	}while(!kbhit());
	return 0;
}

