/*---------------------------------------------------------------------------*\

    FILE....: LDROP.CPP
    TYPE....: C++ Console program
    AUTHOR..: Ben Kramer
    DATE....: 31/01/03

    Used to create Loop Drop effect with an OpenSwitch 6 board.
    Remove jumpers JS5 to JS8 on the board.


\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <math.h>
#include "../kbhit.h"

#include "../../src/vpbapi.h"

#define ON_HOOK  0
#define OFF_HOOK 1

#define DROP_OFF 0
#define DROP_ON 1

#define CH 12
#define CHSTART 5
#define CHEND 11
/*
#define CHSTART 10
#define CHEND 10
*/

/* loop drop detector constants */

#define DWINL           90    /* 90ms */
#define DWINH           50    /* 50ms */


int arg_exists(int argc, char *argv[], char *arg);

int main(int argc, char * argv[])
{
	int	        h[CH], ret, state[CH], next_state, i,j;
	VPB_EVENT	e;
	char		s[VPB_MAX_STR];

	for(i=0; i<=CHEND; i++) {
		h[i] = vpb_open(1,i+1);
		vpb_disable_event(h[i], VPB_MRING);
		state[i] = ON_HOOK;
	}

	do {
		for (j=0; j<=500; j+=10){
			// Check for events and ignore em!
			ret = vpb_get_event_async(&e);

			printf("Using %d ms delay",j);
			// Make then perform a loop drop
			for(i=CHSTART; i<=CHEND; i++) {
				vpb_user_ring_station_sync(h[i],DROP_ON);
				vpb_sleep(j);
				vpb_user_ring_station_sync(h[i],DROP_OFF);
				printf(".");

				vpb_sleep(50);
			}
			

			printf("\n");
			vpb_sleep(500);
		}
	} while(!kbhit());

	vpb_sleep(2000);
	for(i=0; i<CH; i++) {
		vpb_close(h[i]);
	}

	return 0;
}

int arg_exists(int argc, char *argv[], char *arg) {
  int i;

  for(i=0; i<argc; i++)
    if (strcmp(argv[i],arg) == 0)
      return i;

  return 0;
}






