/*---------------------------------------------------------------------------*\

    FILE....: ldcount2.CPP
    TYPE....: C++ Console program
    AUTHOR..: Ben Kramer
    DATE....: 31/01/03

    Takes all channels offhook and then waits for loop drops
    This will also check for double detection.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <math.h>
#include <time.h>
#include "../kbhit.h"

#include "../../src/vpbapi.h"

#define MAX_CH 12

int arg_exists(int argc, char *argv[], char *arg);

int main(int argc, char * argv[])
{
	int	        h[MAX_CH],i,ret,arg,ch,ldc[MAX_CH],dldc[MAX_CH];
	int		lastdrop, thisdrop,junk;
	thisdrop=lastdrop=0;

	VPB_EVENT	e;
	char		s[VPB_MAX_STR];

	junk=time(NULL);
	printf("starttime %d",junk);


	h[0] = vpb_open(1,1);
	ch = vpb_get_ports_per_card();
	vpb_close(h[0]);

	for(i=0; i<ch; i++) {
		h[i] = vpb_open(1,i+1);
		vpb_sethook_sync(h[i],VPB_OFFHOOK);
		ldc[i]=0;
		dldc[i]=0;
	}

	printf("Press any key to start test!\n");
	do {
		ret = vpb_get_event_async(&e);
		vpb_sleep(100);
	} while(!kbhit());

	printf("Test started!\n");

	do {
		ret = vpb_get_event_async(&e);
		if (ret == VPB_OK) {
			vpb_translate_event(&e, s);
			if (e.type == VPB_DROP) {
				thisdrop = time(NULL);
				if (( thisdrop - lastdrop) < 2 ) {
					dldc[e.handle]++;
					printf("Double Ldrop on ch %d, total: %d \n",e.handle,dldc[e.handle]);
				}
				else {
					ldc[e.handle]++;
					printf("Ldrop on ch %d, total: %d \n",e.handle,ldc[e.handle]);
				}
				lastdrop=thisdrop;
			}

//			printf("%s",s);
		}
		vpb_sleep(100);

	} while(!kbhit());

	for(i=0; i<ch; i++) {
		vpb_sethook_sync(h[i],VPB_ONHOOK);
		vpb_close(h[i]);
	}

	return 0;
}

int arg_exists(int argc, char *argv[], char *arg) {
  int i;

  for(i=0; i<argc; i++)
    if (strcmp(argv[i],arg) == 0)
      return i;

  return 0;
}








