/*-------------------------------------------------------------*\

  FILE..: GENCALLERID.CPP
  AUTHOR: John Kostogiannis
  DATE..: 9/7/00

  Generate a bit sequence confoming to the Caller ID Data Link
  Layer specs.  This data can then be used to driver a CID
  modulator.
  
  Generates:

  300 Channel seizure stage (CSS) bits
  180 Mark stage (MSS) bits
  ASCII data conforming to Data link Layer specs.

\*-------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdio.h>

#define CSS_STAGE	300
#define MSS_STAGE	180
#define MAX_BITS	1000
#define NMESS	        30

void gen_css (short *t,int *next_pos); 
void gen_mss (short *t,int *next_pos);
void gen_ASCII (short *t, int *next_pos, char ascii_chr);
 
int main()
{
	FILE *fp;
	short bits[MAX_BITS];
	int start_pos = 0;
	int next_pos = 0;
	int pos_flag = 0;
	int i = 0;		
	int n = 0;
	unsigned char checksum;
	
	fp = fopen("..\\callerid\\gcallid.bin","wb");
	assert(fp != NULL);

	/*-------generate CSS ---------*/
	
	gen_css (bits,&next_pos); 

	/*-------generate MSS ---------*/
	
	gen_mss (&bits[next_pos],&next_pos); 

	/*-------generate 9569 3848 ---------*/

	gen_ASCII (&bits[next_pos], &next_pos, 0x80);	// message type
	gen_ASCII (&bits[next_pos], &next_pos, NMESS);	// message length

	// message.....
	gen_ASCII (&bits[next_pos], &next_pos, '9');
	gen_ASCII (&bits[next_pos], &next_pos, '5');
	gen_ASCII (&bits[next_pos], &next_pos, '6');
	gen_ASCII (&bits[next_pos], &next_pos, '9');
	gen_ASCII (&bits[next_pos], &next_pos, '3');
	gen_ASCII (&bits[next_pos], &next_pos, '8');
	gen_ASCII (&bits[next_pos], &next_pos, '4');
	gen_ASCII (&bits[next_pos], &next_pos, '8');
	for(i=0; i<NMESS-8; i++)
		gen_ASCII (&bits[next_pos], &next_pos, 0x0);

	checksum = 0x80 + NMESS + '9' + '5' + '6' + '9' +'3' + '8' + '4' + '8';
	checksum = ~checksum + 1;
	gen_ASCII (&bits[next_pos], &next_pos, checksum);

	// some dummy data to pad end
	gen_ASCII (&bits[next_pos], &next_pos, 0xff);
	gen_ASCII (&bits[next_pos], &next_pos, 0xff);
	gen_ASCII (&bits[next_pos], &next_pos, 0xff);
	gen_ASCII (&bits[next_pos], &next_pos, 0xff);
	assert(next_pos < MAX_BITS);
	
	/*---- copy buffer to File ---------*/
	fwrite(bits,sizeof(short),next_pos,fp);
	
	fclose(fp);
	return(1);
}

void gen_css (short *t,int *next_pos) 
{
	
	int i;	

	for (i=0;i<CSS_STAGE;i+=2)
	{
		*t++ = 1;
		*t++ = 0;
	}
	*next_pos = *next_pos + CSS_STAGE;
}	
		
void gen_mss (short *t,int *next_pos) 
{
	
	int i;	

	for (i=0;i<MSS_STAGE;i++)
	{
		*t++ = 1;
	}
	*next_pos = *next_pos + MSS_STAGE;
}	

void gen_ASCII (short *t, int *next_pos, char ascii_chr)
{
	int i;

	/* generate start_bit */

	*t++ = 0;

	/* generate char bits */

	for(i=0;i<8;i++)
		*t++ = (ascii_chr>>i) & 0x1;

	/* generate stop_bit */

	*t++ = 1;

	*next_pos = *next_pos+10;
}

