/*--------------------------------------------------------------------------*\

    FILE....: DSPRUN.CPP
    TYPE....: Linux C++ Program
    AUTHOR..: David Rowe
    DATE....: 28/4/01

    Places DSP in run mode.  Used while developing V4PCI.

    Compile: gcc dsprun.cpp -o dsprun libvpb.a -Wall
    Run....: ./dsprun

\*--------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/ioctl.h>
#include <unistd.h>

#include "../src/vpb_ioctl.h"

int main() {
	int               fd;
	int               ret;
	VPB_DATA          params;

	fd = open("/dev/vpb0",O_RDWR);
	assert(fd != -1);

	// set up ioctl params
	params.length = 0;
	params.dsp_addr = 0;
	params.pci_num = 0;

	// Place DSP in Run
	params.data = NULL;
	ret = ioctl(fd, VPB_IOC_PCI_DSP_RUN, &params);
	assert(ret != -1);
	return 0;
}
