/*-------------------------------------------------------------------------*\

  FILE..: DECCID.CPP
  AUTHOR: David Rowe
  DATE..: 10/5/01

  Test program for testing Caller ID decoding module.  Attempts to decode
  CID signal from a wave file.

\*-------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "../../src/vpbapi.h"
#include "../../src/wobbly.h"

void wave_get_size(void *wv, unsigned long *bytes);

int main(int argc, char *argv[])
{
	int ret;
	void *w;
	unsigned long sz_bytes;
	char number_str[VPB_MAX_STR];
	//char *buf = new char[8000*10];
	VPB_CID	*my_cid = new VPB_CID;

	if (argc != 2) {
		printf("usage: deccid2 InputWaveFile\n");
		exit(0);
	}

	vpb_cid_debug_on("debug.txt");

	vpb_wave_open_read(&w, argv[1]);
	wave_get_size(w, &sz_bytes);
	assert(sz_bytes != 0);

	printf("sz_bytes = %ld\n", sz_bytes);
//	while(1){
	char *buf = new char[sz_bytes];
	printf("created buf points to => [%p]\n",buf);
	assert(buf != NULL);
	printf("Read in wave ...\n");
	vpb_wave_read(w, buf, sz_bytes);

	printf("Starting decoding loop...\n");
	ret = vpb_cid_decode2(my_cid, (short*)buf, sz_bytes/sizeof(short));
	if (ret == 0 ){
		printf("Decoded buffer:\n");
		printf("Date/Time [date_time]   = [%s]\n",my_cid->date_time);
		printf("Name/Text [cn]          = [%s]\n",my_cid->cn);
		printf("Number Dialed [cdn]     = [%s]\n",my_cid->cdn);
		printf("Caller Number [cldn]    = [%s]\n",my_cid->cldn);
		printf("Reason absent [ra_cldn] = [%s]\n",my_cid->ra_cldn);
		printf("Reason absent [ra_cn]   = [%s]\n",my_cid->ra_cn);
	/*
		printf("Pres  = [%s]\n",my_cid->pres);
		int i,len_pres;
		len_pres = strlen(my_cid->pres);
		for (i=0;i<len_pres;i++){
			printf("[%c]=>[%x]\n",my_cid->pres[i],(int)my_cid->pres[i]);
		}
	*/
	}
	else {
		printf("Decode failed!\n");
	}

	//printf("used buf points to => [%p]\n",buf);

//	printf("Sleeping....\n");
//	vpb_sleep(2000);
//	printf("==================================\n");

//	}
	delete buf;

	return 0;
}
