/*---------------------------------------------------------------------------*\

	FILE....: conference.cpp
	TYPE....: C Program
	AUTHOR..: David Rowe
	DATE....: 26/10/01

	Demo for conferencing first three ports of card (3 ports furthest from
	motherboard).  

	Usage:
	1. Connect two or three lines to any of the ports.
	2. ./conference to see comamnd line
	3. Ring each of the loop-start lines.
	4. Press enter to finish.

	Examples:

	1) Special example for Simple Simon modded V16 cards, handset 
	plugged into port 4, trunk line in port 1
 
	./conference 4 1 --handset 	

\*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <pthread.h>
#include <string.h>
#include "../../src/vpbapi.h"

#define	BUF_SIZE        160	// size of processing frame (samples) (20ms)

// local functions
void *event_thread(void *pv);
int kbhit();
void add(short c[], short a[], short b[]);
int arg_exists(int argc, char *argv[], char *arg);

int finish;
 
int main(int argc, char *argv[])
{
	pthread_t       ev_thread;
	int             line1, line2, line3, arg;

	if (argc < 2) {
		printf("usage: conference Port1[1..4] Port2[1..4] "
		       "[--port3 Port3[1..4]] [--handset]"
		       "[--dial n] [--hostecho]\n");

		exit(0);
	}

	// initialise 

	line1 = vpb_open(1,atoi(argv[1]));
	line2 = vpb_open(1,atoi(argv[2]));
	if ((arg = arg_exists(argc,argv,"--hostecho"))) {
		vpb_hostecho_opt(line1);
		vpb_hostecho_on(line1);
		vpb_hostecho_on(line2);
	}

	if ((arg = arg_exists(argc,argv,"--offhook"))) {
		vpb_sethook_sync(line2,VPB_OFFHOOK);
	}
	if ((arg = arg_exists(argc,argv,"--port3"))) {
		line3 = vpb_open(1,atoi(argv[arg+1]));
		if ((arg = arg_exists(argc,argv,"--hostecho"))) {
			vpb_hostecho_on(line3);
		}
	}
	else {
		line3 = -1;
	}

	if ((arg = arg_exists(argc,argv,"--dial"))) {
		vpb_sethook_sync(line2,VPB_OFFHOOK);
		vpb_dial_sync(line2,argv[arg+1]);
	}

	if ((arg = arg_exists(argc,argv,"--handset"))) {
		// port 1 is a handset port
		printf("handset.....\n");
		vpb_set_codec_reg(line1, 0x12, 0x7c);
	        vpb_set_codec_reg(line1, 0x0a, 0x20); 
	}
	else {
		line3 = -1;
	}
	vpb_disable_event(line1, VPB_MTONEDETECT);
	vpb_disable_event(line2, VPB_MTONEDETECT);
	if (line3 != -1) vpb_disable_event(line3, VPB_MTONEDETECT);

	// start main processing loop ---------------------------
		
	finish = 0;
	pthread_create(&ev_thread, NULL, event_thread, NULL);
	//param1.src = line1; param1.dest = line2;
	//pthread_create(&aud_thread1, NULL, audio_thread, (void*)&param1);
	//param2.src = line2; param2.dest = line1;
	//pthread_create(&aud_thread2, NULL, audio_thread, (void*)&param2);
	       
	short buf1[BUF_SIZE];
	short buf2[BUF_SIZE];
	short buf3[BUF_SIZE];
	short buf[BUF_SIZE];

	vpb_record_buf_start(line1, VPB_LINEAR);
	vpb_play_buf_start(line1, VPB_LINEAR);
	vpb_record_buf_start(line2, VPB_LINEAR);
	vpb_play_buf_start(line2, VPB_LINEAR);
	if (line3 != -1) {
		vpb_record_buf_start(line3, VPB_LINEAR);
		vpb_play_buf_start(line3, VPB_LINEAR);
	}

	while(!kbhit()) {
		vpb_record_buf_sync(line1, (char*)buf1,sizeof(short)*BUF_SIZE);
		vpb_record_buf_sync(line2, (char*)buf2,sizeof(short)*BUF_SIZE);
		if (line3 != -1) {
			vpb_record_buf_sync(line3, (char*)buf3,
					    sizeof(short)*BUF_SIZE);
		}

		// uncomment this line if you only use the first two ports
		if (line3 == -1) {
			memset(buf3, 0, sizeof(short)*BUF_SIZE); // * line **
		}

		add(buf, buf2, buf3);
		vpb_play_buf_sync(line1, (char*)buf,sizeof(short)*BUF_SIZE);
		add(buf, buf1, buf3);
		vpb_play_buf_sync(line2, (char*)buf, sizeof(short)*BUF_SIZE);
		if (line3 != -1) {
			add(buf, buf1, buf2);
			vpb_play_buf_sync(line3, (char*)buf, 
					  sizeof(short)*BUF_SIZE);
		}
	}

	vpb_record_buf_finish(line1);
	vpb_play_buf_finish(line1);
	vpb_record_buf_finish(line2);
	vpb_play_buf_finish(line2);
	if (line3 != -1) {
		vpb_record_buf_finish(line3);
		vpb_play_buf_finish(line3);
	}

	finish = 1;
	
	// clean up and finish 

	vpb_hostecho_off(line1);
	vpb_hostecho_off(line2);
	vpb_sethook_sync(line1,VPB_ONHOOK);
	vpb_sethook_sync(line2,VPB_ONHOOK);
	if (line3 != -1) {
		vpb_sethook_sync(line3,VPB_ONHOOK);
	}

	return 0;
}	

void *event_thread(void *pv) {
	char	  s[VPB_MAX_STR];
        VPB_EVENT e;

	do {
		// check for events from VPB

		while(vpb_get_event_async(&e) == VPB_OK) {
			vpb_translate_event(&e, s);
			printf(s);

			// take channels off-hook on ring
			if (e.type == VPB_RING) {
				vpb_sethook_sync(e.handle, VPB_OFFHOOK);
			}
		}
		vpb_sleep(10);

	} while(!finish);

	return NULL;
}

void add(short c[], short a[], short b[]) {
	int   i;
	float sam;

	for(i=0; i<BUF_SIZE; i++) {
		sam = a[i] + b[i];
		if (sam > 32767) sam = 32767;
		if (sam < -32767) sam = 32767;
		c[i] = (short)sam;
	}
}

int arg_exists(int argc, char *argv[], char *arg) {
  int i;

  for(i=0; i<argc; i++)
    if (strcmp(argv[i],arg) == 0)
      return i;

  return 0;
}
