/*---------------------------------------------------------------------------*\

    FILE....: BRIDGEALL.CPP
    TYPE....: C++ Console program
    AUTHOR..: David Rowe
    DATE....: 14/4/02

    Uses both bridge resources to bridge all ports.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <math.h>
#include "../kbhit.h"

#include "../../src/vpbapi.h"
#include "../../src/verbose.h"

#define CH 4

int arg_exists(int argc, char *argv[], char *arg);

int main(int argc, char * argv[])
{
	int	        h1,h2,h3,h4,ret;
	VPB_EVENT	e;
	char		s[VPB_MAX_STR];

	if (argc < 3) {
		printf("usage: bridge port1[1..4] port2[1..4] "
		       " port3[1..4] port4[1..4]\n");
		printf("bridges port1 to port2 & port3 to port4\n");
		exit(0);
	}

	h1 = vpb_open(1,atoi(argv[1]));
	h2 = vpb_open(1,atoi(argv[2]));
	h3 = vpb_open(1,atoi(argv[3]));
	h4 = vpb_open(1,atoi(argv[4]));
	vpb_disable_event(h1, VPB_MTONEDETECT);
	vpb_disable_event(h2, VPB_MTONEDETECT);
	vpb_disable_event(h3, VPB_MTONEDETECT);
	vpb_disable_event(h4, VPB_MTONEDETECT);

	vpb_sethook_sync(h1,VPB_OFFHOOK);
	vpb_sethook_sync(h2,VPB_OFFHOOK);
	vpb_sethook_sync(h3,VPB_OFFHOOK);
	vpb_sethook_sync(h4,VPB_OFFHOOK);

	vpb_bridge(h1, h2, VPB_BRIDGE_ON, 1);
	vpb_bridge(h3, h4, VPB_BRIDGE_ON, 2);
	printf("hit return to exit\n");

	do {
		ret = vpb_get_event_async(&e);
		if (ret == VPB_OK) {
			vpb_translate_event(&e, s);
			printf("%s",s);
		}
		vpb_sleep(100);

	} while(!kbhit());

	vpb_bridge(h1, h2, VPB_BRIDGE_OFF, 2);
	vpb_bridge(h3, h4, VPB_BRIDGE_OFF, 2);

	vpb_sethook_sync(h1, VPB_ONHOOK);
	vpb_sethook_sync(h2, VPB_ONHOOK);
	vpb_sethook_sync(h3, VPB_ONHOOK);
	vpb_sethook_sync(h4, VPB_ONHOOK);

	vpb_close(h1);
	vpb_close(h2);
	vpb_close(h3);
	vpb_close(h4);

	return 0;
}

int arg_exists(int argc, char *argv[], char *arg) {
  int i;

  for(i=0; i<argc; i++)
    if (strcmp(argv[i],arg) == 0)
      return i;

  return 0;
}








