/*
  twait4dial.cpp
 John Kostogiannis 15/5/02

  Demonstrates calling using the dial-tone detector:
  - takes port 1 off hook
  - waits for dial tone
  - dials number
*/  
#include "../../src/vpbapi.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "../kbhit.h"

void verbose(int);
int ctwaitforevent(int h, void *timer,int event_type,int data,int timeout_ms);
int finish = 0;

int main(int argc, char *argv[]) {
	int       h1,finished;
        int       tries,fails; 
	void      *timer1;
	int       ret;
	long      SampleTime; 

	if (argc < 6) {
		printf("usage: twait4dial Card Port DialNum wavfile SampleTime\n");
		exit(0);
	}
	
	h1 = vpb_open(atoi(argv[1]), atoi(argv[2]));
	vpb_sethook_sync(h1,VPB_OFFHOOK);
        vpb_timer_open(&timer1, h1, 0, 1000);
 
	printf("waiting for dial tone...\n");
	ret = ctwaitforevent(h1, timer1, VPB_TONEDETECT, VPB_DIAL, 5000);
	if (ret != -1) {
		printf("dial tone!\n");
		vpb_dial_sync(h1, argv[3]);
	}
	else {
		printf("Can't detect Dial Tone\n");
	}

	/*	Start recording to file */

	printf("start recording to file\n");
	vpb_record_file_async(h1,argv[4], 0);
        SampleTime = atol(argv[5]);
	printf("Sampling for %ld secs\n", SampleTime);
	vpb_sleep(SampleTime*1000);
	vpb_record_terminate(h1);
	vpb_sethook_sync(h1, VPB_ONHOOK);
	vpb_close(h1);
	return 0;
}

int ctwaitforevent(int h,void *timer,int event_type,int data,int timeout_ms) {
  char      s[VPB_MAX_STR];
  int       ret, state;
  VPB_EVENT e;   

  vpb_timer_change_period(timer, timeout_ms);
  if (timeout_ms != 0)
    vpb_timer_start(timer);

  state = 1;
  while((state == 1) && !finish) {
    ret = vpb_get_event_ch_async(h, &e);

    if (ret == VPB_OK) {
      vpb_translate_event(&e, s); s[strlen(s)-1]=0;

      if ((e.type == event_type) && (e.data == data)) {
	state = 0;
      }
      if (e.type == VPB_TIMEREXP) {
	state = 2;
      }
    }
    else
      vpb_sleep(100);
  }
	  
  vpb_timer_stop(timer);	
  if (state == 0)
    return e.type;
  else
    return -1;
}

       
