/*---------------------------------------------------------------------------*\

	FILE....: tnumrings.cpp
	TYPE....: C++ Program
	AUTHOR..: John Kostogiannis
	DATE....: 15/5/02

	Places the line off hook once designated number of rings are detected.	
	- Dial number connected to port x.
	- port x  goes off hook after y number of rings
	 
\*--------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include "../../src/vpbapi.h"

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "../kbhit.h"
int main(int argc, char *argv[])
{
	int       h,i;
	VPB_EVENT e;
	char      s[VPB_MAX_STR];
	int       on_hook;
	int       numrings;

	if (argc != 4) {
		printf("usage: tnumrings Card Port NumOfRings\n");
		exit(0);
	}
	numrings = atoi(argv[3]);
        h = vpb_open(atoi(argv[1]), atoi(argv[2]));
	vpb_sethook_sync(h, VPB_ONHOOK);
	printf("Port %s onhook\n", argv[2]);
	on_hook = 1;
	i=0;
	do {
		while(vpb_get_event_async(&e) == VPB_OK) {
			vpb_translate_event(&e, s);
			printf(s);

			// take channels off-hook on ring
			if (e.type == VPB_RING) {
			        i++;
			        if(i>=numrings){  
				  vpb_sethook_sync(e.handle,VPB_OFFHOOK);
				  printf("Port %s offhook\n", argv[2]);
				  on_hook = 0;
				}  
			}
		}
		vpb_sleep(100);
	} while(on_hook);
	while (!kbhit())
	  vpb_sleep(1000);
	vpb_sethook_sync(h, VPB_ONHOOK);
	printf("Port %s onhook\n", argv[2]);
	vpb_close(h);
	return 0;
}



