/*
  tnowait4dial.cpp
  John Kostogiannis 15/5/02

  Demonstrates calling using the dial-tone detector:
  - takes port 1 off hook
  - pause and dail
 
*/

#include "../../src/vpbapi.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "../kbhit.h"

void verbose(int);

int main(int argc, char *argv[]) {
	int       h1;
	int       ret;
	long      SampleTime; 
	VPB_EVENT e;
	char      s[VPB_MAX_STR];

	if (argc < 6) {
		printf("usage: tnowait4dial Card Port DialNum wavfile SampleTime\n");
		exit(0);
	}
	
	h1 = vpb_open(atoi(argv[1]),atoi(argv[2]));
	vpb_sethook_sync(h1,VPB_OFFHOOK);
 	vpb_dial_sync(h1, argv[3]);
	
	do {
		while(vpb_get_event_async(&e) == VPB_OK) {
			vpb_translate_event(&e, s);
			printf(s);
		}
		vpb_sleep(100);	
	} while(!kbhit());


	/*	Start recording to file */

	printf("start recording to file\n");
	vpb_record_file_async(h1,argv[4], 0);
        SampleTime = atol(argv[5]);
	printf("Sampling for %ld secs\n", SampleTime);
	vpb_sleep(SampleTime*1000);
	vpb_record_terminate(h1);
	vpb_sethook_sync(h1, VPB_ONHOOK);
	vpb_close(h1);
	return 0;
}

