/*
  emitest.cpp
  David Rowe 16/5/02

  Test software for emi testing, requested by Austest:
  - takes port off hook
  - dials number
  - waits for x seconds (e.g. 3 minutes)
  - puts port bak on hook
*/

#include "../../src/vpbapi.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

int main(int argc, char *argv[]) {
	int       h;

	if (argc < 4) {
		printf("usage: emitest Port[1..4] Number StartDelay[secs] "
		       " OffHookTime[secs]\n");
		printf("e.g. emitest 4 21 10 180\n");
		printf("will wait 10 seconds after starting, then "
		       "dial the number 21 out of port 4 and wait "
		       "3 minutes before hanging up\n");
		exit(0);
	}
	
	h = vpb_open(1,atoi(argv[1]));
	sleep(atoi(argv[3]));
	vpb_sethook_sync(h,VPB_OFFHOOK);
	sleep(2);
	vpb_dial_sync(h, argv[2]);
	sleep(atoi(argv[4]));
	vpb_sethook_sync(h,VPB_ONHOOK);
	vpb_close(h);

	return 0;
}


