/*
  dialdtmfcont.cpp
  John Kostogiannis 14/5/02

  generate dtmf on tone for a specified period of time.

*/

#include "../../src/vpbapi.h"
#include <stdio.h>
#include <stdlib.h>
#include <string>
#include "../kbhit.h"

int main(int argc, char *argv[]) {
	int       h;
	int       tries;
	unsigned long      tmp_on, tmp_off;
	VPB_TONE  tmp_tone;
	if (argc < 4) {
		printf("usage: %s Card ChNum[1..12] msecs \n",argv[0]);
		exit(0);
	}
        h = vpb_open(atoi(argv[1]),atoi(argv[2]));
		
        vpb_gettone('1',&tmp_tone);
	tmp_on = tmp_tone.ton;
	tmp_off = tmp_tone.toff;    
        tmp_tone.ton = atol(argv[3]);
        tmp_tone.toff = 0;     
        vpb_settone('1',&tmp_tone); 
	tries = 0;

	vpb_sethook_sync(h,VPB_OFFHOOK);
	 
	do {
		tries++;

		// sync versions
		vpb_dial_sync(h, "1");
		tmp_tone.ton = tmp_on;
		tmp_tone.toff = tmp_off;
		vpb_settone('1',&tmp_tone); 
		printf("tries = %d\n",tries);
	} while(!kbhit());
	
	vpb_close(h);
	return 0;
}


