/*---------------------------------------------------------------------------*\

    FILE....: SAMCID.CPP
    TYPE....: C++ program
    AUTHOR..: David Rowe
    DATE....: 21/4/01

    Samples Caller ID to a wave file using V4PCI - used during CID development.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>

#include "../../src/vpbapi.h"
#include "../../src/verbose.h"

#define WAITING   0
#define RECORDING 1
#define FINISHED  2

int main(int argc, char * argv[])
{
	int	        h, ret, rings, state;
	VPB_EVENT       e;
	int             bases[] = {0};

	if (argc != 3) {
		printf("usage: samcid Ch[1..4] WaveFileName\n");
		exit(0);
	}
	verbose(1);
	vpb_seterrormode(VPB_DEVELOPMENT);

	vpb_config(1, bases, "/etc/vpb/vpbmain_pci.out", VPB_V4PCI);
	h = vpb_open(1, atoi(argv[1]));
	vpb_sethook_sync(h, VPB_ONHOOK);

	rings = 0;
	printf("Waiting for first ring.....\n");

	state = WAITING;
	do {
		ret = vpb_get_event_ch_async(h, &e);
		if (ret == VPB_OK) {
			if (e.type == VPB_RING) {
				// sample audio, but leave on-hook
				vpb_record_file_async(h, argv[2], VPB_LINEAR);
				state = RECORDING;
			}
		}	
			
		vpb_sleep(10);
	} while(state != RECORDING);
	
	printf("First ring, recording started..........\n");
	do {
		ret = vpb_get_event_ch_async(h, &e);
		if (ret == VPB_OK) {
			if (e.type == VPB_RING) {
				vpb_record_terminate(h);
				state = FINISHED;
			}
		}	
			
		vpb_sleep(10);
	} while(state != FINISHED);
	
	printf("Second ring, Finished!\n");

	vpb_sleep(1000);

	vpb_close(h);

	return 0;
}



