/*---------------------------------------------------------------------------*\

    FILE....: VPBREG.H
    TYPE....: C Header File
    AUTHOR..: David Rowe
    DATE....: 3/10/97

    Functions used to load configuration database from the PC into the
    VPB DSP.  This database is known as the DSP Registry.  Each VPB has its
    own registry.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#ifndef __VPBREG__
#define __VPBREG__

#include "contypes.h"
#include "dspfifo.h"

/*--------------------------------------------------------------------------*\

				DEFINES

\*--------------------------------------------------------------------------*/

// general defines 

#define	MAXCH		32	// max channels per VPB			

// channel status flags 

#define	RX		0x1	// channel receiving speech		
#define	TX		0x2	// channel transmitting speech		

// registry paths (Windows only)

#define WIN95_PATH		"Enum\\Root\\VPBAdapter"
#define WINNT_PATH		"SYSTEM\\CurrentControlSet\\Services\\vpb"

/*--------------------------------------------------------------------------*\

				TYPEDEFS

\*--------------------------------------------------------------------------*/

// make sure compiler doesnt mess with member alignment

#pragma pack(1)

// structure containing DSP program "registry" info for each VPB 

typedef struct {

    // info below stored in same format on DSP 

    USHORT  data;		// data reg for PC-DSP comms		
    USHORT  numch;		// number of channels			
    USHORT  chstat[MAXCH];	// status of each channel		
    USHORT  a_dnmess;		// addr of "down" message FIFO in DSP	
    USHORT  a_upmess;		// addr of "up" message FIFO in DSP	
    USHORT  szmess;		// size in words of message FIFOs	
    USHORT  a_rxdf[MAXCH];	// addresses of RX FIFOs in DSP		
    USHORT  a_txdf[MAXCH];	// addresses of TX FIFOs in DSP		
    USHORT  szrxdf[MAXCH];	// size of RX FIFOs in DSP		
    USHORT  sztxdf[MAXCH];	// size of TX FIFOs in DSP		
    USHORT  lsf;		// length of superframe in words	

    // PC specific info 
	
    USHORT  base;		// base address of VPB			
    char    firm[MAX_STR];	// firmware path and file name
    DspFifo *dnmess;		// ptr to down message DSP FIFO in PC	
    DspFifo *upmess;		// ptr to down message DSP FIFO in PC	
    DspFifo *rxdf[MAXCH];	// ptrs to RX DSP FIFO info in PC	
    DspFifo *txdf[MAXCH];	// ptrs to TX DSP FIFO info in PC
    USHORT  model;		// VPB model
    USHORT  ddmodel;		// VPB Device Driver model
    ULONG   szRelayBuf;	        // size of PC side of relay buffer in words
				// note this same size is use for all DSP
				// fifos, ie message Qs and sample fifos

    float   defRecordGain;      // default record (Tx) gain
    float   defPlayGain;        // default play (Rx) gain
    float   defSRecordGain;      // default record (Tx) gain for station
    float   defSPlayGain;        // default play (Rx) gain for station

    int     hybdefs_overwrite;  // true if defaults overwritten
    USHORT  defbal1;            // default codec balance register 1
    USHORT  defbal2;            // default codec balance register 2
    USHORT  defbal3;            // default codec balance register 3 	
    USHORT  defSbal1;            // default codec balance register 1 for station
    USHORT  defSbal2;            // default codec balance register 2 for station
    USHORT  defSbal3;            // default codec balance register 3 for station

    USHORT  hp_enable;	        // hp filter enabled
    USHORT  echo_mode;          // DSPFIFO_ECHO for host echo canc, 0 ow
    void    *ec[MAXCH];	        // host ec data
    USHORT  echo_en;            // non-zero to enable host ec
    USHORT  dighyb;             // non-zero for digital hyb bal filter
    char    *dighybfile;        // path and file name of hyb file

    char    mdate[12];		// Manufacture Date
    char    revision[8];	// Revision number
    char    serial_n[10];	// Serial Number

    float   defRecordGainDown;  // record gain down control for better DTMF
    
} VPBREG; 

#pragma pack()	// back to default alignment

/*-------------------------------------------------------------------------*\

			    FUNCTION HEADERS

\*-------------------------------------------------------------------------*/

class VPBRegister {
public:
	VPBREG	*reg;
	VPBRegister(USHORT *num);
	~VPBRegister();
};

void vpbreg_load_default_tones(int numch);
int vpbreg_get_model();

#endif	/* #ifndef __VPBREG__	*/

