// gpioctl.h    Include file for Generic Port I/O Example Driver
//
// Define the IOCTL codes we will use.  The IOCTL code contains a command
// identifier, plus other information about the device, the type of access
// with which the file must have been opened, and the type of buffering.
//
// Robert B. Nelson (Microsoft)     March 1, 1993

// Device type           -- in the "User Defined" range."

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include "contypes.h"

#define VPB_TYPE 0xa014		

// The IOCTL function codes from 0x800 to 0xFFF are for customer use.

// Port module test routine

#define IOCTL_VPB_TPORT CTL_CODE( VPB_TYPE, 0x901, METHOD_BUFFERED, FILE_ANY_ACCESS )

// HIP functions

#define IOCTL_VPB_HIP_OPEN CTL_CODE( VPB_TYPE, 0x902, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_VPB_HIP_CLOSE CTL_CODE( VPB_TYPE, 0x903, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_VPB_HIP_INIT_VPB CTL_CODE( VPB_TYPE, 0x904, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_VPB_HIP_DSP_RESET CTL_CODE( VPB_TYPE, 0x905, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_VPB_HIP_DSP_RUN CTL_CODE( VPB_TYPE, 0x906, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_VPB_HIP_WRITE_DSP_SRAM CTL_CODE( VPB_TYPE, 0x907, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_VPB_HIP_READ_DSP_SRAM CTL_CODE( VPB_TYPE, 0x908, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_VPB_HIP_SET_PIP CTL_CODE( VPB_TYPE, 0x909, METHOD_BUFFERED, FILE_ANY_ACCESS )

// FIFO functions

#define IOCTL_VPB_FIFO_CREATE CTL_CODE( VPB_TYPE, 0x90a, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_VPB_FIFO_DESTROY CTL_CODE( VPB_TYPE, 0x90b, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_VPB_FIFO_WRITE CTL_CODE( VPB_TYPE, 0x90c, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_VPB_FIFO_READ CTL_CODE( VPB_TYPE, 0x90d, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_VPB_FIFO_HOW_FULL CTL_CODE( VPB_TYPE, 0x90e, METHOD_BUFFERED, FILE_ANY_ACCESS )

// DSP FIFO functions

#define IOCTL_VPB_DSP_FIFO_CREATE CTL_CODE( VPB_TYPE, 0x90f, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_VPB_DSP_FIFO_DESTROY CTL_CODE( VPB_TYPE, 0x910, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_VPB_DSP_FIFO_WRITE CTL_CODE( VPB_TYPE, 0x911, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_VPB_DSP_FIFO_READ CTL_CODE( VPB_TYPE, 0x912, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_VPB_DSP_FIFO_HOW_FULL CTL_CODE( VPB_TYPE, 0x913, METHOD_BUFFERED, FILE_ANY_ACCESS )

// RELAY FIFO functions

#define IOCTL_VPB_RELAY_FIFO_CREATE CTL_CODE( VPB_TYPE, 0x914, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_VPB_RELAY_FIFO_DESTROY CTL_CODE( VPB_TYPE, 0x915, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_VPB_RELAY_FIFO_HOW_FULL CTL_CODE( VPB_TYPE, 0x916, METHOD_BUFFERED, FILE_ANY_ACCESS )

// kernal mode thread functions

#define IOCTL_VPB_CREATE_THREAD CTL_CODE( VPB_TYPE, 0x917, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_VPB_TERMINATE_THREAD CTL_CODE( VPB_TYPE, 0x918, METHOD_BUFFERED, FILE_ANY_ACCESS )

// used for passing HIP function params across Ring3/Ring0 barrier

typedef struct {
	USHORT	base;
	USHORT	board;
	USHORT	addr;
	USHORT	length;
	USHORT	enables;
} HIP_PARAMS,*PHIP_PARAMS;

// diagnostic info from device driver

typedef struct {
	USHORT	MaxTardiness;
} VPB_STATS, *PVPB_STATS;

// used to pass data to FIFO and DSP routines

#define	RELAY_UP	1	// relay FIFO transfers from DSP to PC
#define	RELAY_DOWN	0	// relay FIFO transfers from PC to DSP

typedef struct {
	USHORT	index;		// kernal mode fifo index

	void	*ppc;		// ptr to user mode buffer
	ULONG	length;		// length of transfer/buffer
	int		ret;		// return value

	USHORT	board;		// board number
	USHORT	id;			// config manager id
	ULONG	pdsp;		// address of dsp FIFO in dsp memory
	ULONG	dsplength;	// length of DSP FIFO

	USHORT	direction;	// REALY_UP or RELAY_DOWN direction of relay FIFO
} FIFO_PARAMS, *PFIFO_PARAMS;
