/*---------------------------------------------------------------------------*\

    FILE....: TONEG.H
    TYPE....: C Header File
    AUTHOR..: David Rowe
    DATE....: 5/11/97

    Programmable tone generator functions.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#ifndef __TONEG__
#define __TONEG__

#include "contypes.h"

/*--------------------------------------------------------------------------*\

			     MESSAGE INTERFACE

\*--------------------------------------------------------------------------*/

/*
   To program the tone gnerator, messages are passed to this module
   via the toneg_start_tone function.  The format of the message is as
   follows:

   USHORT	length
   USHORT	message_type = TONEG
   short	freq1
   short	freq2
   short	freq3
   USHORT	mag1
   USHORT	mag2
   USHORT	mag3
   short        duration_h 		(MS word)
   short        duration_l 		(LS word)
   short 	total_h    		(MS word)
   short 	total_l			(LS word)
   USHORT	id			// object id (see config.c)

   Notes:
   ------

   1. freq1 and freq2 are 2cos(w) in Q14.
   2. Magnitudes in Q15 wrt 0dbm0.
   3. duration in samples, silence in samples.
*/

/*--------------------------------------------------------------------------*\

				FUNCTIONS

\*--------------------------------------------------------------------------*/

void toneg_open(void **toneg, USHORT ch);
void toneg_close(void *toneg);
void toneg_start(void *tgv, word mess[]);
int  toneg_play(void *tgv, short buf[], USHORT n);
void toneg_reset(void *tgv, word mess[]);

#endif	/* #ifndef __TONEG__	*/

