/*--------------------------------------------------------------------------*\

    FILE....: pci.h
    TYPE....: C++ module
    AUTHOR..: David Rowe
    DATE....: 23/12/01

    Low level interface to kernel mode driver for V12PCI.

\*--------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         V12PCI CT Card Software

         Copyright (C) David Rowe 2001 david@voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#ifndef __PCI__
#define __PCI__

typedef struct {

	char	date[16];
	char	revision[10];
	char	serial_n[12];

} VPB_MAN_DATA;

int pci_open(void);
int pci_close(int fd);

void pci_block_write(
 int             fd, 
 unsigned short board, 
 unsigned short addr, 
 unsigned short length, 
 unsigned short *buf
);

void pci_block_read
(
 int            fd,
 unsigned short board, 
 unsigned short addr, 
 unsigned short length, 
 unsigned short *buf
);

void pci_write
(
 int            fd,
 unsigned short board, 
 unsigned short addr, 
 unsigned short data
);

void pci_read
(
 int            fd,
 unsigned short board, 
 unsigned short addr, 
 unsigned short *data
);

void pci_read_buf_stats
(
 int            fd,
 unsigned short board, 
 int            length, 
 unsigned short *buf
);

void pci_wd_en_l(int fd, unsigned short board);
void pci_wd_en_h(int fd, unsigned short board);
void pci_wd_reset(int fd, unsigned short board);
int pci_rx_fifo_how_full(int fd, unsigned short board);
int pci_tx_fifo_how_empty(int fd, unsigned short board);
void pci_rx_fifo_block_read
(
 int            fd,
 unsigned short board, 
 int            length, 
 unsigned short *buf
 );

void pci_tx_fifo_block_write
(
 int            fd,
 unsigned short board, 
 int            length, 
 unsigned short *buf
 );

int pci_khook_read(int fd, unsigned short board, int ch);
int pci_kring_read(int fd, unsigned short board, int ch);
int pci_kldrop_read(int fd, unsigned short board, int ch);

void pci_conf_leave ( int fd, unsigned short board, unsigned short ch);
void pci_conf_join ( int fd, unsigned short board, unsigned short ch, unsigned short data);

void pci_sbridge_on ( int fd, unsigned short board, unsigned short ch, int board2, int ch2);
void pci_sbridge_off ( int fd, unsigned short board, unsigned short ch);

void pci_ee_mandata_read(
 int            fd,
 unsigned short board,
 VPB_MAN_DATA 	*md
);
void pci_loopback_off (int fd, unsigned short board);
void pci_loopback_on (int fd, unsigned short board);

void pci_hostecho_off (int fd, unsigned short port);
void pci_hostecho_on (int fd, unsigned short port);
void pci_hostecho_opt (int fd, unsigned short method );

int pci_block_iicread(
		int fd,
		unsigned short board,
		unsigned short addr,
		unsigned short length,
		unsigned short *buf);

int pci_block_iicwrite(
		int fd,
		unsigned short board,
		unsigned short addr,
		unsigned short length,
		unsigned short *buf);

void pci_fsync_read(int fd, unsigned short board, int *resync,
		                   int *testpattern);
void pci_read_rawtdm(int fd,  unsigned short board,
                     unsigned short length, unsigned short *buf );
#endif
