/*---------------------------------------------------------------------------*\

    FILE....: MESSAGES.H
    TYPE....: C Header File
    AUTHOR..: David Rowe
    DATE....: 20/11/97

    Constants that define the message types and lengths.  Messages are used
    to communicate between the DSP and the PC.

    Note: Exact same version of this file must be used by both firmware
    and driver to ensure DSP and PC are speaking the same language!

\*---------------------------------------------------------------------------*/

#ifndef __MESSAGES__
#define __MESSAGES__

/*-------------------------------------------------------------------------*\

			       DEFINES

\*-------------------------------------------------------------------------*/

/*
   CONVENTIONS:
   ------------

   1. Mesage originating at PC have a prefix PC_, messages from DSP have the
      prefix DSP_.
   2. The next word in the message usually describes the DSP module the
      message in coming from/going to.
*/

/* PC -> DSP messages -----------------------------------------------------*/

#define	PC_PING			1	/* see if VPB DSP is alive		*/
#define PC_TONED_ST		2	/* call progress state table		*/
#define	PC_TONEG		3	/* generate tone			*/
#define	PC_CONFIG_OBJ		4	/* create object in config manager	*/
#define	PC_CONFIG_WIRE		5	/* connect two objs using software wire	*/
#define	PC_CONFIG_CLR		6	/* connect two objs using software wire	*/
#define	PC_CONFIG_RUN		7	/* enable config signal processing	*/
#define	PC_CONFIG_STOP		8	/* disable config signal processing	*/
#define	PC_CODEC_OFFHK		9	/* take channel off hook		*/
#define	PC_CODEC_ONHK		10	/* place channel on hook		*/
#define	PC_CONFIG_EN		11	/* enable an object			*/
#define	PC_CONFIG_DIS		12	/* disable an object			*/
#define	PC_SPI_LOAD 		13	/* tell DSP to send comp. load report	*/
#define	PC_SPI_RESLOAD 		14	/* tell DSP to reset comp load stats	*/
#define	PC_CONFIG_NWIRE		15	/* remove software wire			*/
#define	PC_CODEC_BREAK		16	/* loop break				*/
#define	PC_CODEC_UPGAIN		17	/* change UP direction gain		*/
#define	PC_CODEC_DNGAIN		18	/* change DOWN direction gain		*/
#define	PC_TONED_DEBUG		19	/* places toned in debug mode		*/
#define	PC_VOX_UPDATE		20	/* change VOX levels			*/
#define PC_AGC_UPDATE  		21	/* chage AGC parameters			*/
#define	PC_CONFIG_8K		22	/* configure an object for 8k operation */
#define	PC_CONFIG_6K		23	/* configure an object for 6k operation */
#define PC_CONFIG_PACK		24	/* configure packing ratio 		*/
#define PC_ECHO_FORCEON		25	/* start force echo canc to adapt	*/
#define PC_ECHO_FORCEOFF	26	/* stop force echo canc to adapt	*/
#define	PC_COMP_ADPCMRES	27	/* reset ADPCM state variables		*/
#define PC_ECHO_INIT		28	/* set adaptive coefficients to zero	*/
#define PC_CONFIG_ZEROBUF	29	/* connect an object to the zero buffer	*/
#define PC_CONFIG_FLUSHFIFO	30	/* flush a DSP fifo	 		*/
#define PC_ECHO_ENABLE		31	/* start echo cancellation		*/
#define PC_ECHO_DISABLE		32	/* stop echo canc (continue adaption)	*/
#define PC_TONEG_RESET		33	/* reset tone generator			*/
#define	PC_CONFIG_EN2		34	/* enable an two objects		*/
#define	PC_CONFIG_RESFA		35	/* reset FIFO alarm			*/
#define	PC_CONFIG_ENLIST	36	/* enable a list of objects		*/
#define PC_FIXGAIN_UPDATE	37	/* change the fixed gain		*/
#define	PC_CODEC_OFFHKSCP	38	/* off hook, audio from SCP             */
#define	PC_CODEC_GEN		39	/* general codec config message         */
#define	PC_SPI_BRIDGE		40	/* firmware level bridging              */
#define	PC_SPI_BRIDGE_OFF	41	/* turn off firmware level bridging     */
#define	PC_STATION_OFF		42	/* turn station port off                */
#define	PC_STATION_ON		43	/* turn station port on                 */
#define	PC_RING_OFF		44	/* start ringing a station port         */
#define	PC_RING_ON		45 	/* stop ringing a station port          */
#define PC_WD_ENABLE		46	/* enable/disable V12PCI watchdog timer */
#define PC_WD_RESET		47  	/* reset V12PCI watchdog timer          */
#define	PC_URING_OFF		48  	/* start ringing a station port         */
#define	PC_URING_ON		49  	/* stop ringing a station port          */
#define	PC_CONF_JOIN   		50  	/* Join a conference			*/
#define	PC_CONF_LEAVE  		51  	/* Leave a conference			*/
#define	PC_SPI_SBRIDGE		52	/* Soft firmware level bridging		*/
#define	PC_SPI_SBRIDGE_OFF	53	/* turn off Soft firmware level bridging*/
#define	PC_LOOPBACK_ON		54	/* turn on tx-rx soft loop back         */
#define	PC_LOOPBACK_OFF		55	/* turn off tx-rx soft loop back        */
#define	PC_HOSTECHO_ON		56	/* turn on host echo cancelation 	*/
#define	PC_HOSTECHO_OFF		57	/* turn off host echo cancelation 	*/
#define	PC_HOSTECHO_OPT		58	/* Set host echo optimization*/
#define PC_TONED_ST_DEL		59	/* call progress state table delete	*/

/* length of PC -> DSP messages (if fixed) */

#define PC_LPING		2
#define	PC_LTONEG		13
#define	PC_LCONFIG_OBJ		6
#define	PC_LCONFIG_WIRE		4
#define	PC_LCONFIG_CLR		2
#define	PC_LCONFIG_RUN		2
#define	PC_LCONFIG_STOP		2
#define	PC_LCODEC_OFFHK		3
#define	PC_LCODEC_ONHK		3
#define	PC_LCONFIG_EN		3
#define	PC_LCONFIG_DIS		3
#define	PC_LSPI_LOAD		2
#define	PC_LSPI_RESLOAD		2
#define	PC_LCONFIG_NWIRE	3
#define	PC_LCODEC_BREAK		4
#define	PC_LCODEC_UPGAIN	4
#define	PC_LCODEC_DNGAIN	4
#define	PC_LTONED_DEBUG		5
#define	PC_LVOX_UPDATE		10
#define	PC_LAGC_UPDATE		9
#define	PC_LCONFIG_8K		3
#define	PC_LCONFIG_6K		3
#define PC_LCONFIG_PACK		4
#define PC_LECHO_FORCEON	3
#define PC_LECHO_FORCEOFF	3
#define	PC_LCOMP_ADPCMRES	3
#define	PC_LECHO_INIT		3
#define PC_LCONFIG_ZEROBUF 	3
#define PC_LCONFIG_FLUSHFIFO 	3
#define PC_LECHO_ENABLE		3
#define PC_LECHO_DISABLE 	3
#define PC_LTONEG_RESET  	3
#define	PC_LCONFIG_EN2		4
#define	PC_LCONFIG_RESFA	3
#define PC_LFIXGAIN_UPDATE 	4
#define	PC_LCODEC_OFFHKSCP	3
#define	PC_LCODEC_GEN           5
#define PC_LSPI_SBRIDGE          5
#define PC_LSPI_SBRIDGE_OFF      5
#define PC_LSPI_BRIDGE          5
#define PC_LSPI_BRIDGE_OFF      5
#define	PC_LSTATION_OFF	        3
#define	PC_LSTATION_ON	        3
#define	PC_LRING_OFF	        4
#define	PC_LRING_ON	        4
#define PC_LWD_ENABLE           3
#define PC_LWD_RESET	        2
#define	PC_LURING_OFF	        3
#define	PC_LURING_ON	        3
#define	PC_LCONF_JOIN	        4 // msg,bd,p,r
#define	PC_LCONF_LEAVE	        3 // msg,bd,p
#define	PC_LLOOPBACK_ON		2
#define	PC_LLOOPBACK_OFF	2
#define	PC_LHOSTECHO_ON		3
#define	PC_LHOSTECHO_OFF	3
#define	PC_LHOSTECHO_OPT	3

/* DSP -> PC messages -----------------------------------------------------*/

#define	DSP_PONG	1	/* reply to PC_PING			*/
#define	DSP_ERROR	2	/* see error message defs		*/
#define	DSP_TONED	4	/* tone det tone detected		*/
#define	DSP_TONEDOK	5	/* tone det state table OK		*/
#define DSP_TONEG	6	/* tone generator finished		*/
#define	DSP_CONFIG_AF	7	/* address of channel fifo		*/
#define	DSP_DTMF	8	/* DTMF digit detected			*/
#define	DSP_CONFIG_FUO	9	/* FIFO UP overflow			*/
#define	DSP_CONFIG_FDU	10	/* FIFO DOWN underflow			*/
#define	DSP_COMM_MOF	11	/* DSP up message FIFO overflow		*/
#define	DSP_CODEC_RING	12	/* RING rising edge detected		*/
#define	DSP_SPI_LOAD	13	/* computational load report		*/
#define	DSP_CODEC_BKEN	14	/* loop break finished			*/
#define	DSP_DEBUG_LONG	15	/* upload a long to PC for debug	*/
#define	DSP_DEBUG_ARRAY	16	/* upload an array of shorts to PC 	*/
#define	DSP_DEBUG_STACK	17	/* upload current stack position 	*/
#define	DSP_TONED_LOG	18	/* upload tone det debug info		*/
#define	DSP_VOXON	19	/* voice channel BUSY			*/
#define	DSP_VOXOFF	20	/* voice switch IDLE			*/
#define	DSP_FIFODIS	21	/* FIFO has been disabled		*/
#define	DSP_CODEC_HKOFF	22	/* station port off hook                */
#define	DSP_CODEC_HKON	23	/* station port on hook                 */
#define	DSP_RING_OFF	24	/* RING falling edge detected		*/
#define	DSP_DROP	25	/* Loop drop detector                   */
#define	DSP_CODEC_FLASH 26	/* station port hook flash              */
#define	DSP_DTMF_DOWN	27	/* DTMF key DOWN event                  */

/* length of DSP -> PC messages (if fixed) */

#define DSP_LPONG	2
#define	DSP_LERROR	3
#define	DSP_LTONED	4
#define	DSP_LTONEDOK	3
#define	DSP_LTONEG	3
#define	DSP_LCONFIG_AF	5
#define	DSP_LDTMF	4
#define	DSP_LCONFIG_FUO	3
#define	DSP_LCONFIG_FDU	3
#define	DSP_LCOMM_MOF 	2
#define	DSP_LCODEC_RING	3
#define	DSP_LSPI_LOAD	11
#define	DSP_LCODEC_BKEN	3
#define	DSP_LDEBUG_LONG	5
#define	DSP_LDEBUG_STACK 4
#define	DSP_LTONED_LOG	16
#define	DSP_LVOXON	3
#define	DSP_LVOXOFF	3
#define	DSP_LFIFODIS	3
#define	DSP_LCODEC_HKOFF 3	
#define	DSP_LCODEC_HKON	 3	
#define	DSP_LRING_OFF    3
#define	DSP_LDROP        3
#define	DSP_LCODEC_FLASH 3
#define	DSP_LDTMF_DOWN	 4	

/* error message defines */

#define	TONED_TABLE	0	/* error downloading TONED state table	  */
#define	TONEG_BUSY	1	/* tone generator busy			  */
#define	CONFIG_SZIDENT	2	/* object identifer too big		  */
#define	CONFIG_SZCH	3	/* channel number too big		  */
#define	CONFIG_CLASS	4	/* bad class				  */
#define	CONFIG_MEM	5	/* out of memory 			  */
#define	CONFIG_WIRE	6	/* invalid wire 			  */
#define	CONFIG_INPS	7	/* two many inputs to object		  */
#define	CONFIG_IT	8	/* Error during config_iterate		  */
#define	CONFIG_MESS	9	/* error passing message to object	  */
#define	VPBMAIN_MESSAGE	10	/* unknown message type	in dispatcher	  */
#define	CONFIG_NWIRE	11	/* invalid wire while disconnecting	  */

/* configuration object types, used to define signal processing objects */

#define CODEC_AD	0	/* codec A/D (signal into VPB)		  */
#define CODEC_DA	1	/* codec D/A (signal out of VPB)	  */
#define	FIFO_UP		2	/* transfers signal from VPB to PC	  */
#define	FIFO_DOWN	3	/* transfers signal form PC to VPB	  */
#define	TONEG		4	/* tone generator			  */
#define	DTMF		5	/* dtmf decoder				  */
#define	CPFILTER	6	/* call progress filter			  */
#define LIN2ALAW	7	/* linear to alaw	 		  */
#define ALAW2LIN	8	/* alaw to linear			  */
#define LIN2MULAW	9	/* linear to mu-law	 		  */
#define MULAW2LIN	10	/* mu-law to linear			  */
#define LIN2ADPCM	11	/* linear to Oki ADPCM	 		  */
#define ADPCM2LIN	12	/* Oki ADPCM to linear			  */
#define	TONED		13	/* tone detector			  */
#define	ECHO		14	/* echo canceller			  */
#define	DELAY		15	/* one frame delay			  */
#define	ADC_8K		16	/* VLC A-to-D decimated to 8kSps	  */
#define	VOX		17	/* Voice-operated switch (crude grunt det */
#define	AGC		18	/* Automatic gain control		  */
#define PACK		19	/* Packs 4 adpcm codes into 16bits	  */
#define UNPACK		20	/* Unpacks 16bits into 4 adpcm codes   	  */
#define PACKED_FIFO_UP	21	/* Transfers packed ADPCM to PC	  	  */
#define PACKED_TEST_SOURCE  22  /* Known source for testing pack\unpack	  */
#define ADC_24K		23	/* VLC ADC at 24kSps			  */
#define FIFO_UP_24K	24	/* Transfers 24kHz signals to PC	  */
#define FIRD		25	/* Low pass decimating FIR Filter  	  */
#define DEC24K_TO_8K	26	/* Simple decimation by 3		  */
#define FIFO_DOWN_24K	27	/* Transfers 24kHz signals to VLC	  */
#define PACKED_FIFO_DOWN    28	/* Transfers packed samples from PC to DSP*/
#define FIXGAIN		29	/* fixed gain block			  */
#define SCP_ENC		30	/* Speech codec processer encoder         */
#define SCP_DEC		31	/* Speech codec processer decoder         */
#define ADDER		32	/* two-input adder                        */

/* parameters for programming Call progress detectors, see CALLPROG.H */

#define	TIMER 	0
#define	RISING	1
#define	FALLING	2

#endif	/* #ifndef __MESSAGES__	*/
