/*---------------------------------------------------------------------------*\

    FILE....: MAPDEV.CPP
    TYPE....: WIN32 C++ Function
    AUTHOR..: John Kostogiannis
    DATE....: 6/11/97

    Functions used to map the board and channel number to a handle and 
	vice versa.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdlib.h>
#include <stdio.h>

#include "wobbly.h"
#include "mapdev.h"
#include "apifunc.h"

/*--------------------------------------------------------------------------*\

	FUNCTION.: mapdevtohndle
	AUTHOR...: John Kostogiannis
	DATE.....: 25/11/97

	Maps the board number and channel number to a handle, this function
	assumes four channels per board.

\*--------------------------------------------------------------------------*/

int mapdevtohndle(USHORT brdnum, USHORT chnum)
{  
	int hndle;
	
	assert(chnum < 12);

	switch(model) {
	case VPB_VPB4:
		hndle = brdnum<<2;
		hndle	+= chnum;
		break;
	case VPB_VPB8L:
		hndle = brdnum<<3;
		hndle	+= chnum;
		break;
	case VPB_V12PCI:
		hndle = brdnum*12 + chnum;
		break;
	default:
		assert(0);
	}

	return(hndle);
}

/*--------------------------------------------------------------------------*\

	FUNCTION.: maphndletodev
	AUTHOR...: John Kostogiannis
	DATE.....: 25/11/97

	Maps the handle to board number and channel number.  This function
	assumes four channels per board.

\*--------------------------------------------------------------------------*/

void maphndletodev(int hndle, USHORT *brdnum, USHORT *chnum)
{  
	switch(model) {
	case VPB_VPB4:
		*brdnum = hndle & 0xfffc;
		*brdnum = *brdnum>>2;
		*chnum = hndle & 0x3;
		break;
	case VPB_VPB8L:
		*brdnum = hndle & 0xfff8;
		*brdnum = *brdnum>>3;
		*chnum = hndle & 0x7;
		break;
	case VPB_V12PCI:
		*brdnum = hndle / 12;
		*chnum = hndle % 12;
		break;
	default:
		assert(0);
	}
}
