/*---------------------------------------------------------------------------*\

    FILE....: kring.h
    TYPE....: C Function
    AUTHOR..: David Rowe
    DATE....: 17/8/02

    Kernel based ring detection module for V12PCI, links with hda.c

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2002 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#ifndef __KRING__
#define __KRING__

void *kring_open(unsigned short *base2);
void kring_close(void *kring);
void kring_sample(void *kring, int btb,unsigned long *sigbuffer);
int kring_read(void *kring, int ch);

// user supplied support functions, must be linked in by caller

void *kring_malloc(int size);
void kring_free(void *mem);
int kring_readw(unsigned short *addr);

#endif





