/*--------------------------------------------------------------------------*\

    FILE....: HIP.H
    TYPE....: C++ Module Header File
    AUTHOR..: David Rowe
    DATE....: 19/11/97

    VPB access functions that implement the PC side of the HIP.

\*--------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#ifndef __HIP__
#define __HIP__

#include "contypes.h"

/*--------------------------------------------------------------------------*\

				CLASS

\*--------------------------------------------------------------------------*/

class baseHipData;

class Hip {
	baseHipData	*d;
public:
	Hip(int DeviceDriverModel);
	~Hip();
	void InitVpb(USHORT base);
	void DspReset(USHORT board);
	void DspRun(USHORT board);
	void WriteDspSram(USHORT board, USHORT addr, USHORT length, word *buf);
	void ReadDspSram(USHORT board, USHORT addr, USHORT length, word *buf);
	void WriteIic(USHORT board, USHORT addr, USHORT length, word *buf);
	void ReadIic(USHORT board, USHORT addr, USHORT length, word *buf);
	void EeRead(USHORT board, USHORT addr, USHORT length, word *buf);
	void SetPip(USHORT board, char enables);
	void *GethndFile();
	int  GetDeviceDriverModel();
};

/*--------------------------------------------------------------------------*\

				FUNCTIONS

\*--------------------------------------------------------------------------*/

// only implemented in hipplx.cpp, not other hip implementations
int hipplx_GetNumCards();

#endif	/* #ifndef __HIP__	*/










