/*--------------------------------------------------------------------------*\

    FILE....: hdaport.h
    TYPE....: C++ module
    AUTHOR..: David Rowe
    DATE....: 14/1/02

    Interface to HDA card ports.

\*--------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         V12PCI CT Card Software

         Copyright (C) David Rowe 2002 david@voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#ifndef __HDAPORT__
#define __HDAPORT__

#define HDAPORT_ABSENT  -1
#define HDAPORT_LOOP    0
#define HDAPORT_STATION 1

class hdaport {
 public:
	//hdaport();
	void init(int fd, int card, int port);
	void set_loop_onhook();
	void set_loop_offhook();
	void set_audio_on();
	void set_audio_off();
	void set_ring_on();
	void set_ring_off();
	void set_tx_timeslot(int timeslot);
	void set_rx_timeslot(int timeslot);
	int get_tx_timeslot() { return tx_timeslot;}
	int get_rx_timeslot() { return rx_timeslot;}
	void set_tx_gain(unsigned char gain);
	void set_rx_gain(unsigned char gain);
	void set_codec_reg(unsigned char reg, unsigned char value);
        int get_codec_reg(unsigned char reg);
	void set_config(int loop_or_station);
	void conf_join(int resource);
	void conf_leave();
	void sbridge_on(int board,int port);
	void sbridge_off();
	int get_config();
        int read_status_word(unsigned short flagmask);
	int read_iic( unsigned short addr, unsigned short length, unsigned short *buf);
	int write_iic( unsigned short addr, unsigned short length, unsigned short *buf)	;

 private:
	void send_control_word(unsigned short cword);
        int read_control_byte(unsigned short cword);	

	int            fd, card, port, tx_timeslot, rx_timeslot;
	unsigned char  latch_bits;
	int            config;
};

#endif


