/*---------------------------------------------------------------------------*\

    FILE....: echo.h

    Host based echo canceller based on two path model.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#ifndef __ECHO__
#define __ECHO__

#define ECHO_TAPS   128

typedef struct {
	float a[128];     // fixed echo model
	float a2[128];    // adaptive echo model 
	float a3[128];    // snap-shot of a2 mid way thru WINDOW 
	float Ly;               // input (y) short term average
	float Le;               // fixed output (e) short average
	float Le2;              // adaptive output (e) short average
	float Le3;              // snap shot of Le2, when a2 is sampled
	float Ls;               // ref (y) short term average
	float memLy[128]; // previous Ly values
	int   lyi;              // index into memLy array
	int   hang;             // hangover counter
	int   dt;               // non-zero when Geigel detects doubletalk
	int   sup;              // non-zero when supressor active
	int   adapt;            // zero to disable adaption
	float beta;             // adaption constant
        int   ok_count;         // number of ok samples so far in WINDOW 
        float Ey;
        float y_oldest;
	unsigned long seed;
} ECHO_SV;

int echo_open(void **pv);
void echo_set_opt(int method);
void echo_close(void *pv);
void echo(void *pv, float e[], float y[], float s[], int n);
void echo_adapt(void *pv, int adapt);

#endif








