/*---------------------------------------------------------------------------*\

    FILE....: DSPFIFO.H
    TYPE....: C Header File
    AUTHOR..: David Rowe
    DATE....: 20/11/97

    Functions used to read and write to First In First Out (DSPFIFO) queues in
    the DSP, thus facilitating PC to DSP data transfer.  The word length of
    the DSPFIFOs is 16 bits.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#ifndef __DSPFIFO__
#define __DSPFIFO__

#include "contypes.h"
#include "hip.h"
#include "fifo.h" 

/*--------------------------------------------------------------------------*\

				  DEFINES

\*--------------------------------------------------------------------------*/

// Error codes 

#define OK		0	// no problems 				
#define	DSPFIFO_FULL	1	// DSP FIFO full			
#define	DSPFIFO_EMPTY	2	// DSP FIFO empty			

// direction of DSP FIFO (necessary for relay implementation)

#define DSPFIFO_UP	1
#define DSPFIFO_DOWN	0

// switch for type of fifo

#define	DSPFIFO_NORMAL	0      
#define	DSPFIFO_RELAY	1      // large PC buffer used on early NT driver
#define	DSPFIFO_ECHO	2      // host echo cancelling

/*-------------------------------------------------------------------------*\

				    CLASS

\*-------------------------------------------------------------------------*/

class baseDspFifoData;

class DspFifo {
public:
	baseDspFifoData	*d;

        // used for host echo canceller (DSPFIFO_ECHO) mode
        int         mode;
        Fifo        *fifo;          // regular PC fifo for buffered signal

	DspFifo(Hip *hip, USHORT board, USHORT fifo_addr, int dir, int mode);
	DspFifo(int direction, int sz, int mode);
	~DspFifo();
	int Write(word *buf, USHORT size);
	int Read(word *buf, USHORT size);
	int DSPWrite(word *buf, USHORT size);
	int DSPRead(word *buf, USHORT size);
	int HowFull(void);
	int DspHowFull(void);
	int HowEmpty(void);
};

// functions

void dspfifo_open(ULONG szRelayBuf);
void dspfifo_close();
void *dspfifo_echo_start_thread(int b, int ch);
void dspfifo_echo_stop_thread(void *pv);
void dspfifo_echo_thread(void *data);

#endif	// #ifndef __DSPFIFO__	

