/*---------------------------------------------------------------------------*\

    FILE....: DIGBUF.H
    TYPE....: C++ Header file
    AUTHOR..: David Rowe
    DATE....: 22/4/98

	Classes that implement Computer Telephony (CT) "DIGBUF", high level
	classes for developing CT apps.  These classes sit on top of the
	VPB API, and are modelled on the VB voice controls.
	 
\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#ifndef __DIGBUF__
#define __DIGBUF__

#include "contypes.h"

// digbuf_read return codes 

#define OK				0 				
#define	DIGBUF_EMPTY	2

// function headers

void *digbuf_open(USHORT numch, USHORT size);
void digbuf_write(void *digbuf, USHORT chdev, USHORT digit);
int digbuf_read(void *digbuf, USHORT chdev, USHORT *digit);
void digbuf_clear(void *digbuf, USHORT chdev);
void digbuf_close(void *digbuf);

#endif	// __DIGBUF__
