/*---------------------------------------------------------------------------*\

    FILE....: COFF.H
    TYPE....: C++ Function Header File
    AUTHOR..: David Rowe
    DATE....: 19/11/97

    Functions that boot DSP and extract symbol addresses using COFF files.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#ifndef __COFF__
#define __COFF__

#include "contypes.h"
#include "hip.h"

/*-------------------------------------------------------------------------*\

							FUNCTION HEADERS
	
\*-------------------------------------------------------------------------*/

void coff_load_dsp_firmware(Hip *hip, USHORT board, char coff_file[]);
void coff_check_dsp_firmware(Hip *hip, USHORT board, char coff_file[]);
void coff_get_address(char coff_file[], char symbol[], unsigned long *addr);
long coff_construct_image(char coff_file[], USHORT buf[], long buf_len);

#endif	/* #ifndef __COFF__	*/

