/*---------------------------------------------------------------------------*\

    FILE....: COMP.H
    TYPE....: C Header File
    AUTHOR..: David Rowe
    DATE....: 16/10/97

    Compression functions.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#ifndef __COMP__
#define __COMP__

#include "contypes.h"


/*--------------------------------------------------------------------------*\

				DEFINES

\*--------------------------------------------------------------------------*/

/*
   Scale factors define the number of right shifts to convert a 16 bit word
   to a format suitable for input to the compression functions.

   For example, the maximum value for mu-law is 8192, therefore to convert
   a 16 word (max 32767) to a maximum of 8192 we shift two places to the
   right.
*/

#define MULAW_SCALE     2	/* scales linear to mulaw	*/
#define ALAW_SCALE      3	/* scales linear to alaw 	*/
#define ADPCM_SCALE     4	/* scales linear to ADPCM 	*/

/*--------------------------------------------------------------------------*\

				FUNCTIONS

\*--------------------------------------------------------------------------*/

/* C versions */

void mulaw_encode(char mulaw[], short linear[], USHORT sz);
void mulaw_decode(short linear[], char mulaw[], USHORT sz);

void alaw_encode(char alaw[], short linear[], USHORT sz);
void alaw_decode(short linear[], char alaw[], USHORT sz);

void adpcmini_open(void **states);
void adpcmini_close(void *states);
void adpcmini_reset_states(void *states);
void adpcm_encode(void *states, USHORT codes[], short X[], USHORT n);
void adpcm_decode(void *states, short X_[], USHORT codes[], USHORT n);

void adpcm_pack(USHORT codes[], USHORT packed[], USHORT n);
void adpcm_unpack(USHORT codes[], USHORT packed[], USHORT n);

#endif	/* #ifndef __COMP__	*/

